package antlr;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class PreservingFileWriter extends FileWriter
{
  protected File target_file;
  protected File tmp_file;

  public PreservingFileWriter(String paramString)
    throws IOException
  {
    super(paramString + ".antlr.tmp");
    this.target_file = new File(paramString);
    String str = this.target_file.getParent();
    if (str != null)
    {
      File localFile = new File(str);
      if (!localFile.exists())
        throw new IOException("destination directory of '" + paramString + "' doesn't exist");
      if (!localFile.canWrite())
        throw new IOException("destination directory of '" + paramString + "' isn't writeable");
    }
    if ((this.target_file.exists()) && (!this.target_file.canWrite()))
      throw new IOException("cannot write to '" + paramString + "'");
    this.tmp_file = new File(paramString + ".antlr.tmp");
  }

  public void close()
    throws IOException
  {
    BufferedReader localBufferedReader1 = null;
    BufferedWriter localBufferedWriter = null;
    try
    {
      super.close();
      char[] arrayOfChar1 = new char[1024];
      if (this.target_file.length() == this.tmp_file.length())
      {
        char[] arrayOfChar2 = new char[1024];
        localBufferedReader1 = new BufferedReader(new FileReader(this.tmp_file));
        BufferedReader localBufferedReader2 = new BufferedReader(new FileReader(this.target_file));
        int m = 1;
        label164: 
        while (m != 0)
        {
          int j = localBufferedReader1.read(arrayOfChar1, 0, 1024);
          int k = localBufferedReader2.read(arrayOfChar2, 0, 1024);
          if (j != k)
          {
            m = 0;
            break;
          }
          if (j == -1)
            break;
          for (int n = 0; ; n++)
          {
            if (n >= j)
              break label164;
            if (arrayOfChar1[n] == arrayOfChar2[n])
              continue;
            m = 0;
            break;
          }
        }
        localBufferedReader1.close();
        localBufferedReader2.close();
        localBufferedReader1 = localBufferedReader2 = null;
        if (m != 0)
          jsr 87;
      }
      localBufferedReader1 = new BufferedReader(new FileReader(this.tmp_file));
      localBufferedWriter = new BufferedWriter(new FileWriter(this.target_file));
      while (true)
      {
        int i = localBufferedReader1.read(arrayOfChar1, 0, 1024);
        if (i == -1)
          break;
        localBufferedWriter.write(arrayOfChar1, 0, i);
      }
    }
    finally
    {
      if (localBufferedReader1 != null)
        try
        {
          localBufferedReader1.close();
        }
        catch (IOException localIOException1)
        {
        }
      if (localBufferedWriter != null)
        try
        {
          localBufferedWriter.close();
        }
        catch (IOException localIOException2)
        {
        }
      if ((this.tmp_file != null) && (this.tmp_file.exists()))
      {
        this.tmp_file.delete();
        this.tmp_file = null;
      }
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.PreservingFileWriter
 * JD-Core Version:    0.6.0
 */