package antlr;

import antlr.collections.AST;
import antlr.collections.impl.BitSet;

public class MismatchedTokenException extends RecognitionException
{
  String[] tokenNames;
  public Token token;
  public AST node;
  String tokenText = null;
  public static final int TOKEN = 1;
  public static final int NOT_TOKEN = 2;
  public static final int RANGE = 3;
  public static final int NOT_RANGE = 4;
  public static final int SET = 5;
  public static final int NOT_SET = 6;
  public int mismatchType;
  public int expecting;
  public int upper;
  public BitSet set;

  public MismatchedTokenException()
  {
    super("Mismatched Token: expecting any AST node", "<AST>", -1, -1);
  }

  public MismatchedTokenException(String[] paramArrayOfString, AST paramAST, int paramInt1, int paramInt2, boolean paramBoolean)
  {
    super("Mismatched Token", "<AST>", paramAST == null ? -1 : paramAST.getLine(), paramAST == null ? -1 : paramAST.getColumn());
    this.tokenNames = paramArrayOfString;
    this.node = paramAST;
    if (paramAST == null)
      this.tokenText = "<empty tree>";
    else
      this.tokenText = paramAST.toString();
    this.mismatchType = (paramBoolean ? 4 : 3);
    this.expecting = paramInt1;
    this.upper = paramInt2;
  }

  public MismatchedTokenException(String[] paramArrayOfString, AST paramAST, int paramInt, boolean paramBoolean)
  {
    super("Mismatched Token", "<AST>", paramAST == null ? -1 : paramAST.getLine(), paramAST == null ? -1 : paramAST.getColumn());
    this.tokenNames = paramArrayOfString;
    this.node = paramAST;
    if (paramAST == null)
      this.tokenText = "<empty tree>";
    else
      this.tokenText = paramAST.toString();
    this.mismatchType = (paramBoolean ? 2 : 1);
    this.expecting = paramInt;
  }

  public MismatchedTokenException(String[] paramArrayOfString, AST paramAST, BitSet paramBitSet, boolean paramBoolean)
  {
    super("Mismatched Token", "<AST>", paramAST == null ? -1 : paramAST.getLine(), paramAST == null ? -1 : paramAST.getColumn());
    this.tokenNames = paramArrayOfString;
    this.node = paramAST;
    if (paramAST == null)
      this.tokenText = "<empty tree>";
    else
      this.tokenText = paramAST.toString();
    this.mismatchType = (paramBoolean ? 6 : 5);
    this.set = paramBitSet;
  }

  public MismatchedTokenException(String[] paramArrayOfString, Token paramToken, int paramInt1, int paramInt2, boolean paramBoolean, String paramString)
  {
    super("Mismatched Token", paramString, paramToken.getLine(), paramToken.getColumn());
    this.tokenNames = paramArrayOfString;
    this.token = paramToken;
    this.tokenText = paramToken.getText();
    this.mismatchType = (paramBoolean ? 4 : 3);
    this.expecting = paramInt1;
    this.upper = paramInt2;
  }

  public MismatchedTokenException(String[] paramArrayOfString, Token paramToken, int paramInt, boolean paramBoolean, String paramString)
  {
    super("Mismatched Token", paramString, paramToken.getLine(), paramToken.getColumn());
    this.tokenNames = paramArrayOfString;
    this.token = paramToken;
    this.tokenText = paramToken.getText();
    this.mismatchType = (paramBoolean ? 2 : 1);
    this.expecting = paramInt;
  }

  public MismatchedTokenException(String[] paramArrayOfString, Token paramToken, BitSet paramBitSet, boolean paramBoolean, String paramString)
  {
    super("Mismatched Token", paramString, paramToken.getLine(), paramToken.getColumn());
    this.tokenNames = paramArrayOfString;
    this.token = paramToken;
    this.tokenText = paramToken.getText();
    this.mismatchType = (paramBoolean ? 6 : 5);
    this.set = paramBitSet;
  }

  public String getMessage()
  {
    StringBuffer localStringBuffer = new StringBuffer();
    switch (this.mismatchType)
    {
    case 1:
      localStringBuffer.append("expecting " + tokenName(this.expecting) + ", found '" + this.tokenText + "'");
      break;
    case 2:
      localStringBuffer.append("expecting anything but " + tokenName(this.expecting) + "; got it anyway");
      break;
    case 3:
      localStringBuffer.append("expecting token in range: " + tokenName(this.expecting) + ".." + tokenName(this.upper) + ", found '" + this.tokenText + "'");
      break;
    case 4:
      localStringBuffer.append("expecting token NOT in range: " + tokenName(this.expecting) + ".." + tokenName(this.upper) + ", found '" + this.tokenText + "'");
      break;
    case 5:
    case 6:
      localStringBuffer.append("expecting " + (this.mismatchType == 6 ? "NOT " : "") + "one of (");
      int[] arrayOfInt = this.set.toArray();
      for (int i = 0; i < arrayOfInt.length; i++)
      {
        localStringBuffer.append(" ");
        localStringBuffer.append(tokenName(arrayOfInt[i]));
      }
      localStringBuffer.append("), found '" + this.tokenText + "'");
      break;
    default:
      localStringBuffer.append(super.getMessage());
    }
    return localStringBuffer.toString();
  }

  private String tokenName(int paramInt)
  {
    if (paramInt == 0)
      return "<Set of tokens>";
    if ((paramInt < 0) || (paramInt >= this.tokenNames.length))
      return "<" + String.valueOf(paramInt) + ">";
    return this.tokenNames[paramInt];
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.MismatchedTokenException
 * JD-Core Version:    0.6.0
 */