package antlr;

import antlr.collections.impl.BitSet;

public class MismatchedCharException extends RecognitionException
{
  public static final int CHAR = 1;
  public static final int NOT_CHAR = 2;
  public static final int RANGE = 3;
  public static final int NOT_RANGE = 4;
  public static final int SET = 5;
  public static final int NOT_SET = 6;
  public int mismatchType;
  public int foundChar;
  public int expecting;
  public int upper;
  public BitSet set;
  public CharScanner scanner;

  public MismatchedCharException()
  {
    super("Mismatched char");
  }

  public MismatchedCharException(char paramChar1, char paramChar2, char paramChar3, boolean paramBoolean, CharScanner paramCharScanner)
  {
    super("Mismatched char", paramCharScanner.getFilename(), paramCharScanner.getLine(), paramCharScanner.getColumn());
    this.mismatchType = (paramBoolean ? 4 : 3);
    this.foundChar = paramChar1;
    this.expecting = paramChar2;
    this.upper = paramChar3;
    this.scanner = paramCharScanner;
  }

  public MismatchedCharException(char paramChar1, char paramChar2, boolean paramBoolean, CharScanner paramCharScanner)
  {
    super("Mismatched char", paramCharScanner.getFilename(), paramCharScanner.getLine(), paramCharScanner.getColumn());
    this.mismatchType = (paramBoolean ? 2 : 1);
    this.foundChar = paramChar1;
    this.expecting = paramChar2;
    this.scanner = paramCharScanner;
  }

  public MismatchedCharException(char paramChar, BitSet paramBitSet, boolean paramBoolean, CharScanner paramCharScanner)
  {
    super("Mismatched char", paramCharScanner.getFilename(), paramCharScanner.getLine(), paramCharScanner.getColumn());
    this.mismatchType = (paramBoolean ? 6 : 5);
    this.foundChar = paramChar;
    this.set = paramBitSet;
    this.scanner = paramCharScanner;
  }

  public String getMessage()
  {
    StringBuffer localStringBuffer = new StringBuffer();
    switch (this.mismatchType)
    {
    case 1:
      localStringBuffer.append("expecting ");
      appendCharName(localStringBuffer, this.expecting);
      localStringBuffer.append(", found ");
      appendCharName(localStringBuffer, this.foundChar);
      break;
    case 2:
      localStringBuffer.append("expecting anything but '");
      appendCharName(localStringBuffer, this.expecting);
      localStringBuffer.append("'; got it anyway");
      break;
    case 3:
    case 4:
      localStringBuffer.append("expecting token ");
      if (this.mismatchType == 4)
        localStringBuffer.append("NOT ");
      localStringBuffer.append("in range: ");
      appendCharName(localStringBuffer, this.expecting);
      localStringBuffer.append("..");
      appendCharName(localStringBuffer, this.upper);
      localStringBuffer.append(", found ");
      appendCharName(localStringBuffer, this.foundChar);
      break;
    case 5:
    case 6:
      localStringBuffer.append("expecting " + (this.mismatchType == 6 ? "NOT " : "") + "one of (");
      int[] arrayOfInt = this.set.toArray();
      for (int i = 0; i < arrayOfInt.length; i++)
        appendCharName(localStringBuffer, arrayOfInt[i]);
      localStringBuffer.append("), found ");
      appendCharName(localStringBuffer, this.foundChar);
      break;
    default:
      localStringBuffer.append(super.getMessage());
    }
    return localStringBuffer.toString();
  }

  private void appendCharName(StringBuffer paramStringBuffer, int paramInt)
  {
    switch (paramInt)
    {
    case 65535:
      paramStringBuffer.append("'<EOF>'");
      break;
    case 10:
      paramStringBuffer.append("'\\n'");
      break;
    case 13:
      paramStringBuffer.append("'\\r'");
      break;
    case 9:
      paramStringBuffer.append("'\\t'");
      break;
    default:
      paramStringBuffer.append('\'');
      paramStringBuffer.append((char)paramInt);
      paramStringBuffer.append('\'');
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.MismatchedCharException
 * JD-Core Version:    0.6.0
 */