package antlr;

import antlr.collections.impl.BitSet;
import java.io.IOException;

class LexerGrammar extends Grammar
{
  protected BitSet charVocabulary;
  protected boolean testLiterals = true;
  protected boolean caseSensitiveLiterals = true;
  protected boolean caseSensitive = true;
  protected boolean filterMode = false;
  protected String filterRule = null;

  LexerGrammar(String paramString1, Tool paramTool, String paramString2)
  {
    super(paramString1, paramTool, paramString2);
    BitSet localBitSet = new BitSet();
    for (int i = 0; i <= 127; i++)
      localBitSet.add(i);
    setCharVocabulary(localBitSet);
    this.defaultErrorHandler = false;
  }

  public void generate()
    throws IOException
  {
    this.generator.gen(this);
  }

  public String getSuperClass()
  {
    if (this.debuggingOutput)
      return "debug.DebuggingCharScanner";
    return "CharScanner";
  }

  public boolean getTestLiterals()
  {
    return this.testLiterals;
  }

  public void processArguments(String[] paramArrayOfString)
  {
    for (int i = 0; i < paramArrayOfString.length; i++)
      if (paramArrayOfString[i].equals("-trace"))
      {
        this.traceRules = true;
        this.antlrTool.setArgOK(i);
      }
      else if (paramArrayOfString[i].equals("-traceLexer"))
      {
        this.traceRules = true;
        this.antlrTool.setArgOK(i);
      }
      else
      {
        if (!paramArrayOfString[i].equals("-debug"))
          continue;
        this.debuggingOutput = true;
        this.antlrTool.setArgOK(i);
      }
  }

  public void setCharVocabulary(BitSet paramBitSet)
  {
    this.charVocabulary = paramBitSet;
  }

  public boolean setOption(String paramString, Token paramToken)
  {
    String str = paramToken.getText();
    if (paramString.equals("buildAST"))
    {
      this.antlrTool.warning("buildAST option is not valid for lexer", getFilename(), paramToken.getLine(), paramToken.getColumn());
      return true;
    }
    if (paramString.equals("testLiterals"))
    {
      if (str.equals("true"))
        this.testLiterals = true;
      else if (str.equals("false"))
        this.testLiterals = false;
      else
        this.antlrTool.warning("testLiterals option must be true or false", getFilename(), paramToken.getLine(), paramToken.getColumn());
      return true;
    }
    if (paramString.equals("interactive"))
    {
      if (str.equals("true"))
        this.interactive = true;
      else if (str.equals("false"))
        this.interactive = false;
      else
        this.antlrTool.error("interactive option must be true or false", getFilename(), paramToken.getLine(), paramToken.getColumn());
      return true;
    }
    if (paramString.equals("caseSensitive"))
    {
      if (str.equals("true"))
        this.caseSensitive = true;
      else if (str.equals("false"))
        this.caseSensitive = false;
      else
        this.antlrTool.warning("caseSensitive option must be true or false", getFilename(), paramToken.getLine(), paramToken.getColumn());
      return true;
    }
    if (paramString.equals("caseSensitiveLiterals"))
    {
      if (str.equals("true"))
        this.caseSensitiveLiterals = true;
      else if (str.equals("false"))
        this.caseSensitiveLiterals = false;
      else
        this.antlrTool.warning("caseSensitiveLiterals option must be true or false", getFilename(), paramToken.getLine(), paramToken.getColumn());
      return true;
    }
    if (paramString.equals("filter"))
    {
      if (str.equals("true"))
      {
        this.filterMode = true;
      }
      else if (str.equals("false"))
      {
        this.filterMode = false;
      }
      else if (paramToken.getType() == 24)
      {
        this.filterMode = true;
        this.filterRule = str;
      }
      else
      {
        this.antlrTool.warning("filter option must be true, false, or a lexer rule name", getFilename(), paramToken.getLine(), paramToken.getColumn());
      }
      return true;
    }
    if (paramString.equals("longestPossible"))
    {
      this.antlrTool.warning("longestPossible option has been deprecated; ignoring it...", getFilename(), paramToken.getLine(), paramToken.getColumn());
      return true;
    }
    if (paramString.equals("className"))
    {
      super.setOption(paramString, paramToken);
      return true;
    }
    if (super.setOption(paramString, paramToken))
      return true;
    this.antlrTool.error("Invalid option: " + paramString, getFilename(), paramToken.getLine(), paramToken.getColumn());
    return false;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.LexerGrammar
 * JD-Core Version:    0.6.0
 */