package antlr;

public class CharQueue
{
  protected char[] buffer;
  private int sizeLessOne;
  private int offset;
  protected int nbrEntries;

  public CharQueue(int paramInt)
  {
    if (paramInt < 0)
    {
      init(16);
      return;
    }
    if (paramInt >= 1073741823)
    {
      init(2147483647);
      return;
    }
    int i = 2;
    while (i < paramInt)
      i *= 2;
    init(i);
  }

  public final void append(char paramChar)
  {
    if (this.nbrEntries == this.buffer.length)
      expand();
    this.buffer[(this.offset + this.nbrEntries & this.sizeLessOne)] = paramChar;
    this.nbrEntries += 1;
  }

  public final char elementAt(int paramInt)
  {
    return this.buffer[(this.offset + paramInt & this.sizeLessOne)];
  }

  private final void expand()
  {
    char[] arrayOfChar = new char[this.buffer.length * 2];
    for (int i = 0; i < this.buffer.length; i++)
      arrayOfChar[i] = elementAt(i);
    this.buffer = arrayOfChar;
    this.sizeLessOne = (this.buffer.length - 1);
    this.offset = 0;
  }

  public void init(int paramInt)
  {
    this.buffer = new char[paramInt];
    this.sizeLessOne = (paramInt - 1);
    this.offset = 0;
    this.nbrEntries = 0;
  }

  public final void reset()
  {
    this.offset = 0;
    this.nbrEntries = 0;
  }

  public final void removeFirst()
  {
    this.offset = (this.offset + 1 & this.sizeLessOne);
    this.nbrEntries -= 1;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.CharQueue
 * JD-Core Version:    0.6.0
 */