/*      */ package EDU.oswego.cs.dl.util.concurrent.misc;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.Rendezvous;
/*      */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
/*      */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
/*      */ import java.io.Serializable;
/*      */ 
/*      */ abstract class RNG
/*      */   implements Serializable, Comparable
/*      */ {
/*      */   static final int firstSeed = 4321;
/*      */   static final int rmod = 2147483647;
/*      */   static final int rmul = 16807;
/* 1672 */   static int lastSeed = 4321;
/*      */   static final int smod = 32749;
/*      */   static final int smul = 3125;
/* 1676 */   static final Object constructionLock = RNG.class;
/*      */ 
/* 1682 */   static final SynchronizedInt computeLoops = new SynchronizedInt(16, constructionLock);
/*      */ 
/* 1684 */   static final SynchronizedInt syncMode = new SynchronizedInt(0, constructionLock);
/*      */ 
/* 1686 */   static final SynchronizedInt producerMode = new SynchronizedInt(0, constructionLock);
/*      */ 
/* 1688 */   static final SynchronizedInt consumerMode = new SynchronizedInt(0, constructionLock);
/*      */ 
/* 1690 */   static final SynchronizedInt bias = new SynchronizedInt(0, constructionLock);
/*      */ 
/* 1692 */   static final SynchronizedLong timeout = new SynchronizedLong(100L, constructionLock);
/*      */ 
/* 1694 */   static final SynchronizedInt exchangeParties = new SynchronizedInt(1, constructionLock);
/*      */ 
/* 1696 */   static final SynchronizedInt sequenceNumber = new SynchronizedInt(0, constructionLock);
/*      */ 
/* 1698 */   static final SynchronizedInt itersPerBarrier = new SynchronizedInt(0, constructionLock);
/*      */   static Rendezvous[] exchangers_;
/* 1726 */   final int cloops = computeLoops.get();
/* 1727 */   final int pcBias = bias.get();
/* 1728 */   final int smode = syncMode.get();
/* 1729 */   final int pmode = producerMode.get();
/* 1730 */   final int cmode = consumerMode.get();
/* 1731 */   final long waitTime = timeout.get();
/* 1732 */   Rendezvous exchanger_ = null;
/*      */ 
/*      */   static void reset(int nthreads)
/*      */   {
/* 1703 */     synchronized (constructionLock) {
/* 1704 */       sequenceNumber.set(-1);
/* 1705 */       int parties = exchangeParties.get();
/* 1706 */       if (nthreads < parties) parties = nthreads;
/* 1707 */       if (nthreads % parties != 0)
/* 1708 */         throw new Error("need even multiple of parties");
/* 1709 */       exchangers_ = new Rendezvous[nthreads / parties];
/* 1710 */       for (int i = 0; i < exchangers_.length; i++)
/* 1711 */         exchangers_[i] = new Rendezvous(parties);
/*      */     }
/*      */   }
/*      */ 
/*      */   static long nextSeed()
/*      */   {
/* 1717 */     synchronized (constructionLock) {
/* 1718 */       long s = lastSeed;
/* 1719 */       lastSeed = lastSeed * 3125 % 32749;
/* 1720 */       if (lastSeed == 0)
/* 1721 */         lastSeed = (int)System.currentTimeMillis();
/* 1722 */       return s;
/*      */     }
/*      */   }
/*      */ 
/*      */   synchronized Rendezvous getExchanger()
/*      */   {
/* 1735 */     if (this.exchanger_ == null) {
/* 1736 */       synchronized (constructionLock) {
/* 1737 */         int idx = sequenceNumber.increment();
/* 1738 */         this.exchanger_ = exchangers_[(idx % exchangers_.length)];
/*      */       }
/*      */     }
/* 1741 */     return this.exchanger_;
/*      */   }
/*      */ 
/*      */   public void exchange() throws InterruptedException {
/* 1745 */     Rendezvous ex = getExchanger();
/* 1746 */     Runnable r = (Runnable)ex.rendezvous(new UpdateCommand(this));
/* 1747 */     if (r != null) r.run(); 
/*      */   }
/*      */ 
/*      */   public int compareTo(Object other)
/*      */   {
/* 1751 */     int h1 = hashCode();
/* 1752 */     int h2 = other.hashCode();
/* 1753 */     if (h1 < h2) return -1;
/* 1754 */     if (h1 > h2) return 1;
/* 1755 */     return 0;
/*      */   }
/*      */ 
/*      */   protected final long compute(long l) {
/* 1759 */     int loops = (int)((l & 0x7FFFFFFF) % (this.cloops * 2)) + 1;
/* 1760 */     for (int i = 0; i < loops; i++) l = l * 16807L % 2147483647L;
/* 1761 */     return l == 0L ? 4321L : l; } 
/*      */   protected abstract void set(long paramLong);
/*      */ 
/*      */   protected abstract long internalGet();
/*      */ 
/*      */   protected abstract void internalUpdate();
/*      */ 
/* 1768 */   public long get() { return internalGet(); } 
/* 1769 */   public void update() { internalUpdate(); } 
/* 1770 */   public long next() { internalUpdate(); return internalGet();
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.misc.RNG
 * JD-Core Version:    0.6.0
 */