/*     */ package EDU.oswego.cs.dl.util.concurrent.misc;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
/*     */ import EDU.oswego.cs.dl.util.concurrent.CondVar;
/*     */ import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
/*     */ import EDU.oswego.cs.dl.util.concurrent.Mutex;
/*     */ 
/*     */ public class CVBuffer
/*     */   implements BoundedChannel
/*     */ {
/*     */   private final Mutex mutex;
/*     */   private final CondVar notFull;
/*     */   private final CondVar notEmpty;
/*  10 */   private int count = 0;
/*  11 */   private int takePtr = 0;
/*  12 */   private int putPtr = 0;
/*     */   private final Object[] array;
/*     */ 
/*     */   public CVBuffer(int cap)
/*     */   {
/*  16 */     this.array = new Object[cap];
/*  17 */     this.mutex = new Mutex();
/*  18 */     this.notFull = new CondVar(this.mutex);
/*  19 */     this.notEmpty = new CondVar(this.mutex);
/*     */   }
/*     */ 
/*     */   public CVBuffer() {
/*  23 */     this(DefaultChannelCapacity.get());
/*     */   }
/*     */   public int capacity() {
/*  26 */     return this.array.length;
/*     */   }
/*     */   public void put(Object x) throws InterruptedException {
/*  29 */     this.mutex.acquire();
/*     */     try {
/*  31 */       while (this.count == this.array.length) {
/*  32 */         this.notFull.await();
/*     */       }
/*  34 */       this.array[this.putPtr] = x;
/*  35 */       this.putPtr = ((this.putPtr + 1) % this.array.length);
/*  36 */       this.count += 1;
/*  37 */       this.notEmpty.signal();
/*     */     }
/*     */     finally {
/*  40 */       this.mutex.release();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object take() throws InterruptedException {
/*  45 */     Object x = null;
/*  46 */     this.mutex.acquire();
/*     */     try {
/*  48 */       while (this.count == 0) {
/*  49 */         this.notEmpty.await();
/*     */       }
/*  51 */       x = this.array[this.takePtr];
/*  52 */       this.array[this.takePtr] = null;
/*  53 */       this.takePtr = ((this.takePtr + 1) % this.array.length);
/*  54 */       this.count -= 1;
/*  55 */       this.notFull.signal();
/*     */     }
/*     */     finally {
/*  58 */       this.mutex.release();
/*     */     }
/*  60 */     return x;
/*     */   }
/*     */ 
/*     */   public boolean offer(Object x, long msecs) throws InterruptedException {
/*  64 */     this.mutex.acquire();
/*     */     try {
/*  66 */       if (this.count == this.array.length) {
/*  67 */         this.notFull.timedwait(msecs);
/*  68 */         if (this.count == this.array.length)
/*     */           return false;
/*     */       }
/*  71 */       this.array[this.putPtr] = x;
/*  72 */       this.putPtr = ((this.putPtr + 1) % this.array.length);
/*  73 */       this.count += 1;
/*  74 */       this.notEmpty.signal();
/*     */       return true;
/*     */     }
/*     */     finally {
/*  78 */       this.mutex.release();
/*  79 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public Object poll(long msecs) throws InterruptedException {
/*  83 */     Object x = null;
/*  84 */     this.mutex.acquire();
/*     */     try {
/*  86 */       if (this.count == 0) {
/*  87 */         this.notEmpty.timedwait(msecs);
/*  88 */         if (this.count == 0)
/*     */           return null;
/*     */       }
/*  91 */       x = this.array[this.takePtr];
/*  92 */       this.array[this.takePtr] = null;
/*  93 */       this.takePtr = ((this.takePtr + 1) % this.array.length);
/*  94 */       this.count -= 1;
/*  95 */       this.notFull.signal();
/*     */     }
/*     */     finally {
/*  98 */       this.mutex.release(); } this.mutex.release();
/*     */ 
/* 100 */     return x;
/*     */   }
/*     */ 
/*     */   public Object peek() {
/*     */     try {
/* 105 */       this.mutex.acquire();
/*     */       try {
/* 107 */         if (this.count == 0) {
/*     */           return null;
/*     */         }
/* 110 */         Object localObject2 = this.array[this.takePtr];
/*     */         return localObject2;
/*     */       }
/*     */       finally {
/* 113 */         this.mutex.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 117 */       Thread.currentThread().interrupt();
/* 118 */     }return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.misc.CVBuffer
 * JD-Core Version:    0.6.0
 */