/*      */ package EDU.oswego.cs.dl.util.concurrent.misc;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
/*      */ 
/*      */ class AClongRNG extends RNG
/*      */ {
/* 1829 */   protected final SynchronizedLong acurrent_ = new SynchronizedLong(nextSeed());
/*      */ 
/* 1831 */   protected void set(long l) { throw new Error("No set allowed"); } 
/* 1832 */   protected long internalGet() { return this.acurrent_.get(); }
/*      */ 
/*      */   protected void internalUpdate() {
/* 1835 */     int retriesBeforeSleep = 100;
/* 1836 */     int maxSleepTime = 100;
/* 1837 */     int retries = 0;
/*      */     while (true) {
/* 1839 */       long v = internalGet();
/* 1840 */       long n = compute(v);
/* 1841 */       if (this.acurrent_.commit(v, n))
/* 1842 */         return;
/* 1843 */       retries++; if (retries < retriesBeforeSleep) continue;
/*      */       try {
/* 1845 */         Thread.sleep(n % maxSleepTime);
/*      */       }
/*      */       catch (InterruptedException ex) {
/* 1848 */         Thread.currentThread().interrupt();
/*      */       }
/* 1850 */       retries = 0;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.misc.AClongRNG
 * JD-Core Version:    0.6.0
 */