/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class QueuedExecutor extends ThreadFactoryUser
/*     */   implements Executor
/*     */ {
/*     */   protected Thread thread_;
/*  47 */   protected static Runnable ENDTASK = new Runnable() {
/*     */     public void run() {  } } ;
/*     */   protected volatile boolean shutdown_;
/*     */   protected final Channel queue_;
/*     */   protected final RunLoop runLoop_;
/*     */ 
/*     */   public synchronized Thread getThread()
/*     */   {
/*  59 */     return this.thread_;
/*     */   }
/*     */ 
/*     */   protected synchronized void clearThread()
/*     */   {
/*  64 */     this.thread_ = null;
/*     */   }
/*     */ 
/*     */   public QueuedExecutor(Channel queue)
/*     */   {
/* 118 */     this.queue_ = queue;
/* 119 */     this.runLoop_ = new RunLoop();
/*     */   }
/*     */ 
/*     */   public QueuedExecutor()
/*     */   {
/* 129 */     this(new BoundedLinkedQueue());
/*     */   }
/*     */ 
/*     */   public synchronized void restart()
/*     */   {
/* 140 */     if ((this.thread_ == null) && (!this.shutdown_)) {
/* 141 */       this.thread_ = this.threadFactory_.newThread(this.runLoop_);
/* 142 */       this.thread_.start();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void execute(Runnable command)
/*     */     throws InterruptedException
/*     */   {
/* 157 */     restart();
/* 158 */     this.queue_.put(command);
/*     */   }
/*     */ 
/*     */   public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks()
/*     */   {
/* 171 */     if (!this.shutdown_) try {
/* 172 */         this.queue_.put(ENDTASK);
/*     */       } catch (InterruptedException ex) {
/* 174 */         Thread.currentThread().interrupt();
/*     */       }
/*     */   }
/*     */ 
/*     */   public synchronized void shutdownAfterProcessingCurrentTask()
/*     */   {
/* 186 */     this.shutdown_ = true;
/*     */     try {
/* 188 */       while (this.queue_.poll(0L) != null);
/* 189 */       this.queue_.put(ENDTASK);
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 192 */       Thread.currentThread().interrupt();
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void shutdownNow()
/*     */   {
/* 206 */     this.shutdown_ = true;
/* 207 */     Thread t = this.thread_;
/* 208 */     if (t != null)
/* 209 */       t.interrupt();
/* 210 */     shutdownAfterProcessingCurrentTask();
/*     */   }
/*     */ 
/*     */   protected class RunLoop
/*     */     implements Runnable
/*     */   {
/*     */     protected RunLoop()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*  82 */       label83: 
/*     */       try { while (!QueuedExecutor.this.shutdown_) {
/*  83 */           Runnable task = (Runnable)QueuedExecutor.this.queue_.take();
/*  84 */           if (task == QueuedExecutor.ENDTASK) {
/*  85 */             QueuedExecutor.this.shutdown_ = true;
/*  86 */             break label83;
/*     */           }
/*  88 */           if (task == null) break;
/*  89 */           task.run();
/*  90 */           task = null;
/*     */         }
/*     */       }
/*     */       catch (InterruptedException localInterruptedException)
/*     */       {
/*     */       }
/*     */       finally
/*     */       {
/*  98 */         QueuedExecutor.this.clearThread();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.QueuedExecutor
 * JD-Core Version:    0.6.0
 */