/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.util.Comparator;
/*     */ 
/*     */ public class Heap
/*     */ {
/*     */   protected Object[] nodes_;
/*  33 */   protected int count_ = 0;
/*     */   protected final Comparator cmp_;
/*     */ 
/*     */   public Heap(int capacity, Comparator cmp)
/*     */     throws IllegalArgumentException
/*     */   {
/*  43 */     if (capacity <= 0) throw new IllegalArgumentException();
/*  44 */     this.nodes_ = new Object[capacity];
/*  45 */     this.cmp_ = cmp;
/*     */   }
/*     */ 
/*     */   public Heap(int capacity)
/*     */   {
/*  54 */     this(capacity, null);
/*     */   }
/*     */ 
/*     */   protected int compare(Object a, Object b)
/*     */   {
/*  60 */     if (this.cmp_ == null) {
/*  61 */       return ((Comparable)a).compareTo(b);
/*     */     }
/*  63 */     return this.cmp_.compare(a, b);
/*     */   }
/*     */ 
/*     */   protected final int parent(int k)
/*     */   {
/*  68 */     return (k - 1) / 2; } 
/*  69 */   protected final int left(int k) { return 2 * k + 1; } 
/*  70 */   protected final int right(int k) { return 2 * (k + 1);
/*     */   }
/*     */ 
/*     */   public synchronized void insert(Object x)
/*     */   {
/*  76 */     if (this.count_ >= this.nodes_.length) {
/*  77 */       int newcap = 3 * this.nodes_.length / 2 + 1;
/*  78 */       Object[] newnodes = new Object[newcap];
/*  79 */       System.arraycopy(this.nodes_, 0, newnodes, 0, this.nodes_.length);
/*  80 */       this.nodes_ = newnodes;
/*     */     }
/*     */ 
/*  83 */     int k = this.count_;
/*  84 */     this.count_ += 1;
/*  85 */     while (k > 0) {
/*  86 */       int par = parent(k);
/*  87 */       if (compare(x, this.nodes_[par]) >= 0) break;
/*  88 */       this.nodes_[k] = this.nodes_[par];
/*  89 */       k = par;
/*     */     }
/*     */ 
/*  93 */     this.nodes_[k] = x;
/*     */   }
/*     */ 
/*     */   public synchronized Object extract()
/*     */   {
/* 102 */     if (this.count_ < 1) return null;
/*     */ 
/* 104 */     int k = 0;
/* 105 */     Object least = this.nodes_[k];
/* 106 */     this.count_ -= 1;
/* 107 */     Object x = this.nodes_[this.count_];
/* 108 */     this.nodes_[this.count_] = null;
/*     */     while (true) {
/* 110 */       int l = left(k);
/* 111 */       if (l >= this.count_) {
/*     */         break;
/*     */       }
/* 114 */       int r = right(k);
/* 115 */       int child = (r >= this.count_) || (compare(this.nodes_[l], this.nodes_[r]) < 0) ? l : r;
/* 116 */       if (compare(x, this.nodes_[child]) <= 0) break;
/* 117 */       this.nodes_[k] = this.nodes_[child];
/* 118 */       k = child;
/*     */     }
/*     */ 
/* 123 */     this.nodes_[k] = x;
/* 124 */     return least;
/*     */   }
/*     */ 
/*     */   public synchronized Object peek()
/*     */   {
/* 129 */     if (this.count_ > 0) {
/* 130 */       return this.nodes_[0];
/*     */     }
/* 132 */     return null;
/*     */   }
/*     */ 
/*     */   public synchronized int size()
/*     */   {
/* 137 */     return this.count_;
/*     */   }
/*     */ 
/*     */   public synchronized void clear()
/*     */   {
/* 142 */     for (int i = 0; i < this.count_; i++)
/* 143 */       this.nodes_[i] = null;
/* 144 */     this.count_ = 0;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.Heap
 * JD-Core Version:    0.6.0
 */