/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class BoundedBuffer
/*     */   implements BoundedChannel
/*     */ {
/*     */   protected final Object[] array_;
/*  29 */   protected int takePtr_ = 0;
/*  30 */   protected int putPtr_ = 0;
/*     */ 
/*  32 */   protected int usedSlots_ = 0;
/*     */   protected int emptySlots_;
/*  38 */   protected final Object putMonitor_ = new Object();
/*     */ 
/*     */   public BoundedBuffer(int capacity)
/*     */     throws IllegalArgumentException
/*     */   {
/*  45 */     if (capacity <= 0) throw new IllegalArgumentException();
/*  46 */     this.array_ = new Object[capacity];
/*  47 */     this.emptySlots_ = capacity;
/*     */   }
/*     */ 
/*     */   public BoundedBuffer()
/*     */   {
/*  55 */     this(DefaultChannelCapacity.get());
/*     */   }
/*     */ 
/*     */   public synchronized int size()
/*     */   {
/*  63 */     return this.usedSlots_;
/*     */   }
/*  65 */   public int capacity() { return this.array_.length; }
/*     */ 
/*     */   protected void incEmptySlots() {
/*  68 */     synchronized (this.putMonitor_) {
/*  69 */       this.emptySlots_ += 1;
/*  70 */       this.putMonitor_.notify();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized void incUsedSlots() {
/*  75 */     this.usedSlots_ += 1;
/*  76 */     notify();
/*     */   }
/*     */ 
/*     */   protected final void insert(Object x) {
/*  80 */     this.emptySlots_ -= 1;
/*  81 */     this.array_[this.putPtr_] = x;
/*  82 */     if (++this.putPtr_ >= this.array_.length) this.putPtr_ = 0; 
/*     */   }
/*     */ 
/*     */   protected final Object extract()
/*     */   {
/*  86 */     this.usedSlots_ -= 1;
/*  87 */     Object old = this.array_[this.takePtr_];
/*  88 */     this.array_[this.takePtr_] = null;
/*  89 */     if (++this.takePtr_ >= this.array_.length) this.takePtr_ = 0;
/*  90 */     return old;
/*     */   }
/*     */ 
/*     */   public Object peek() {
/*  94 */     synchronized (this) {
/*  95 */       if (this.usedSlots_ > 0) {
/*  96 */         return this.array_[this.takePtr_];
/*     */       }
/*  98 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void put(Object x) throws InterruptedException
/*     */   {
/* 104 */     if (x == null) throw new IllegalArgumentException();
/* 105 */     if (Thread.interrupted()) throw new InterruptedException();
/*     */ 
/* 107 */     synchronized (this.putMonitor_) {
/* 108 */       while (this.emptySlots_ <= 0) try {
/* 109 */           this.putMonitor_.wait();
/*     */         } catch (InterruptedException ex) {
/* 111 */           this.putMonitor_.notify();
/* 112 */           throw ex;
/*     */         }
/*     */ 
/* 115 */       insert(x);
/*     */     }
/* 117 */     incUsedSlots();
/*     */   }
/*     */ 
/*     */   public boolean offer(Object x, long msecs) throws InterruptedException {
/* 121 */     if (x == null) throw new IllegalArgumentException();
/* 122 */     if (Thread.interrupted()) throw new InterruptedException();
/*     */ 
/* 124 */     synchronized (this.putMonitor_) {
/* 125 */       long start = msecs <= 0L ? 0L : System.currentTimeMillis();
/* 126 */       long waitTime = msecs;
/* 127 */       while (this.emptySlots_ <= 0) {
/* 128 */         if (waitTime <= 0L) return false; try {
/* 129 */           this.putMonitor_.wait(waitTime);
/*     */         } catch (InterruptedException ex) {
/* 131 */           this.putMonitor_.notify();
/* 132 */           throw ex;
/*     */         }
/* 134 */         waitTime = msecs - (System.currentTimeMillis() - start);
/*     */       }
/* 136 */       insert(x);
/*     */     }
/* 138 */     incUsedSlots();
/* 139 */     return true;
/*     */   }
/*     */ 
/*     */   public Object take()
/*     */     throws InterruptedException
/*     */   {
/* 145 */     if (Thread.interrupted()) throw new InterruptedException();
/* 146 */     Object old = null;
/* 147 */     synchronized (this) {
/* 148 */       while (this.usedSlots_ <= 0) try {
/* 149 */           wait();
/*     */         } catch (InterruptedException ex) {
/* 151 */           notify();
/* 152 */           throw ex;
/*     */         }
/*     */ 
/* 155 */       old = extract();
/*     */     }
/* 157 */     incEmptySlots();
/* 158 */     return old;
/*     */   }
/*     */ 
/*     */   public Object poll(long msecs) throws InterruptedException {
/* 162 */     if (Thread.interrupted()) throw new InterruptedException();
/* 163 */     Object old = null;
/* 164 */     synchronized (this) {
/* 165 */       long start = msecs <= 0L ? 0L : System.currentTimeMillis();
/* 166 */       long waitTime = msecs;
/*     */ 
/* 168 */       while (this.usedSlots_ <= 0) {
/* 169 */         if (waitTime <= 0L) return null; try {
/* 170 */           wait(waitTime);
/*     */         } catch (InterruptedException ex) {
/* 172 */           notify();
/* 173 */           throw ex;
/*     */         }
/* 175 */         waitTime = msecs - (System.currentTimeMillis() - start);
/*     */       }
/*     */ 
/* 178 */       old = extract();
/*     */     }
/* 180 */     incEmptySlots();
/* 181 */     return old;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.BoundedBuffer
 * JD-Core Version:    0.6.0
 */