/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.module;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    protected static String getSystemProperty(String name) {
        return TCLAction.UTIL.getSystemProperty(name);
    }

    protected static String getEnvironmentVariable(String name) {
        return TCLAction.UTIL.getEnvironmentVariable(name);
    }

    private static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            @Override
            public String getSystemProperty(String name) {
                return System.getProperty(name);
            }

            @Override
            public String getEnvironmentVariable(String name) {
                return System.getenv(name);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){

            @Override
            public String getSystemProperty(final String name) {
                return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return System.getProperty(name);
                    }
                });
            }

            @Override
            public String getEnvironmentVariable(final String name) {
                return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return System.getenv(name);
                    }
                });
            }
        };

        public String getEnvironmentVariable(String var1);

        public String getSystemProperty(String var1);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            public static String getSystemProperty(String name) {
                return UTIL.getTCLAction().getSystemProperty(name);
            }

            public static String getEnvironmentVariable(String name) {
                return UTIL.getTCLAction().getEnvironmentVariable(name);
            }
        }
    }
}

