/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

class FileUtils {
    FileUtils() {
    }

    static Properties loadArquillianProperties(String propertyName, String defaultName) {
        Properties props = new Properties();
        FileName resourceName = FileUtils.getConfigFileName(propertyName, defaultName);
        InputStream input = FileUtils.loadResource(resourceName);
        if (input != null) {
            try {
                props.load(input);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load Arquillian properties file, " + resourceName.getName(), e);
            }
        }
        props.putAll((Map<?, ?>)System.getProperties());
        return props;
    }

    static InputStream loadArquillianXml(String propertyName, String defaultName) {
        FileName resourceName = FileUtils.getConfigFileName(propertyName, defaultName);
        return FileUtils.loadResource(resourceName);
    }

    static InputStream loadResource(FileName resourceName) {
        InputStream stream = FileUtils.loadClassPathResource(resourceName.getName());
        if (stream == null) {
            stream = FileUtils.loadFileResource(resourceName.getName());
        }
        if (stream == null && !resourceName.isDefault()) {
            throw new IllegalArgumentException("Could not find configured filename as either classpath resource nor file resource: " + resourceName.getName());
        }
        return stream;
    }

    static InputStream loadFileResource(String resourceName) {
        File file = new File(resourceName);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Configuration file could not be found, " + resourceName);
            }
        }
        return null;
    }

    static InputStream loadClassPathResource(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(resourceName);
    }

    static FileName getConfigFileName(String propertyName, String defaultName) {
        String name = System.getProperty(propertyName);
        if (name == null) {
            return new FileName(defaultName, true);
        }
        return new FileName(name, false);
    }

    static class FileName {
        private String name;
        private boolean isDefault;

        FileName(String name, boolean isDefault) {
            this.name = name;
            this.isDefault = isDefault;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDefault() {
            return this.isDefault;
        }
    }
}

