/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resource.aggr.mojo;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.maven.plugin.AbstractMojo;
import org.jasig.resource.aggr.ResourcesAggregator;
import org.jasig.resource.aggr.ResourcesAggregatorImpl;
import org.jasig.resource.aggr.mojo.CommonsLogToMavenLog;

public abstract class AbstractSkinResourcesAggregatorMojo
extends AbstractMojo {
    protected int cssLineBreakColumnNumber = 10000;
    protected boolean disableJsOptimizations = false;
    protected boolean displayJsWarnings = true;
    protected int jsLineBreakColumnNumber = 10000;
    protected boolean obfuscateJs = true;
    protected boolean preserveAllSemiColons = true;
    protected String digestAlgorithm = "MD5";
    protected String encoding;
    protected File baseOutputDirectory;
    protected String sharedJavaScriptDirectory;

    protected ResourcesAggregator createResourcesAggregator() {
        org.apache.maven.plugin.logging.Log log = this.getLog();
        CommonsLogToMavenLog logWrapper = new CommonsLogToMavenLog(log);
        ResourcesAggregatorImpl aggr = new ResourcesAggregatorImpl((Log)logWrapper, this.encoding);
        aggr.setCssLineBreakColumnNumber(this.cssLineBreakColumnNumber);
        aggr.setDisableJsOptimizations(this.disableJsOptimizations);
        aggr.setDisplayJsWarnings(this.displayJsWarnings);
        aggr.setJsLineBreakColumnNumber(this.jsLineBreakColumnNumber);
        aggr.setObfuscateJs(this.obfuscateJs);
        aggr.setPreserveAllSemiColons(this.preserveAllSemiColons);
        aggr.setDigestAlgorithm(this.digestAlgorithm);
        return aggr;
    }

    protected void doAggregation(ResourcesAggregator aggr, File skinConfigurationFile, File skinOutputDirectory) throws IOException {
        org.apache.maven.plugin.logging.Log log = this.getLog();
        if (this.sharedJavaScriptDirectory == null) {
            log.debug((CharSequence)("Aggregating: " + skinConfigurationFile + " into " + skinOutputDirectory));
            aggr.aggregate(skinConfigurationFile, skinOutputDirectory);
        } else {
            File fullSharedJavaScriptDirectory = new File(this.baseOutputDirectory, this.sharedJavaScriptDirectory);
            log.debug((CharSequence)("Aggregating: " + skinConfigurationFile + " into " + skinOutputDirectory + " with shared JS directory " + fullSharedJavaScriptDirectory));
            aggr.aggregate(skinConfigurationFile, skinOutputDirectory, fullSharedJavaScriptDirectory);
        }
    }
}

