/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.servlet.mvc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.widget.service.IDictionaryParsingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ajax/dictionary"})
public class DictionaryDataController {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final String DICT_SERVICE_URL = "http://services.aonaware.com/DictService/DictService.asmx/DefineInDict";
    protected final String DICT_ID_PARAM_NAME = "dictId";
    protected final String WORD_PARAM_NAME = "word";
    private IDictionaryParsingService service;
    private Cache cache;

    @Autowired(required=true)
    public void setDictionaryParsingService(IDictionaryParsingService service) {
        this.service = service;
    }

    @Required
    @Resource(name="definitionCache")
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView getDefinition(HttpServletRequest request, @RequestParam(value="word") String word, @RequestParam(value="dictId") String dict) throws Exception {
        String definition;
        HashMap<String, String> map = new HashMap<String, String>();
        HttpSession session = request.getSession(false);
        if (session == null || !((Boolean)session.getAttribute("hasDictionarySession")).booleanValue()) {
            return new ModelAndView("jsonView", map);
        }
        String cacheKey = this.getCacheKey(word, dict);
        Element cachedElement = this.cache.get((Serializable)((Object)cacheKey));
        if (cachedElement == null) {
            definition = this.getDefinition(word, dict);
            cachedElement = new Element((Serializable)((Object)cacheKey), (Serializable)((Object)definition));
            this.cache.put(cachedElement);
        } else {
            definition = (String)((Object)cachedElement.getValue());
        }
        map.put("definition", definition);
        return new ModelAndView("jsonView", map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDefinition(String word, String dict) {
        StringBuffer url = new StringBuffer();
        url.append("http://services.aonaware.com/DictService/DictService.asmx/DefineInDict");
        url.append("?").append("dictId").append("=").append(dict);
        url.append("&").append("word").append("=").append(word);
        HttpClient client = new HttpClient();
        GetMethod get = null;
        InputStream in = null;
        try {
            get = new GetMethod(url.toString());
            int rc = client.executeMethod((HttpMethod)get);
            if (rc == 200) {
                in = get.getResponseBodyAsStream();
                String def = this.service.getDefinitionFromXml(in);
                String string = StringEscapeUtils.escapeHtml((String)def);
                return string;
            }
            this.log.warn((Object)("Failed to retrieve dictionary feed at " + url.toString() + ":" + rc));
        }
        catch (HttpException e) {
            this.log.warn((Object)"Error proxying url", (Throwable)e);
        }
        catch (IOException e) {
            this.log.warn((Object)"Error proxying url", (Throwable)e);
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return null;
    }

    protected String getCacheKey(String word, String dict) {
        return dict.concat(".").concat(word);
    }
}

