/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.web.skin;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.web.skin.AggregationException;
import org.jasig.portal.web.skin.Css;
import org.jasig.portal.web.skin.IResourcesAggregator;
import org.jasig.portal.web.skin.Js;
import org.jasig.portal.web.skin.Resources;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesAggregatorImpl
implements IResourcesAggregator {
    private static final Log LOG = LogFactory.getLog(ResourcesAggregatorImpl.class);
    private static final String CSS = ".aggr.min.css";
    private static final String JS = ".aggr.min.js";
    protected static final String AGGREGATE_FILE_PREFIX = "uportal3_";
    private int cssLineBreakColumnNumber = 10000;
    private int jsLineBreakColumnNumber = 10000;
    private boolean obfuscateJs = true;
    private boolean displayJsWarnings = true;
    private boolean preserveAllSemiColons = true;
    private boolean disableJsOptimizations = false;

    public int getCssLineBreakColumnNumber() {
        return this.cssLineBreakColumnNumber;
    }

    public void setCssLineBreakColumnNumber(int cssLineBreakColumnNumber) {
        this.cssLineBreakColumnNumber = cssLineBreakColumnNumber;
    }

    public int getJsLineBreakColumnNumber() {
        return this.jsLineBreakColumnNumber;
    }

    public void setJsLineBreakColumnNumber(int jsLineBreakColumnNumber) {
        this.jsLineBreakColumnNumber = jsLineBreakColumnNumber;
    }

    public boolean isObfuscateJs() {
        return this.obfuscateJs;
    }

    public void setObfuscateJs(boolean obfuscateJs) {
        this.obfuscateJs = obfuscateJs;
    }

    public boolean isDisplayJsWarnings() {
        return this.displayJsWarnings;
    }

    public void setDisplayJsWarnings(boolean displayJsWarnings) {
        this.displayJsWarnings = displayJsWarnings;
    }

    public boolean isPreserveAllSemiColons() {
        return this.preserveAllSemiColons;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public boolean isDisableJsOptimizations() {
        return this.disableJsOptimizations;
    }

    public void setDisableJsOptimizations(boolean disableJsOptimizations) {
        this.disableJsOptimizations = disableJsOptimizations;
    }

    @Override
    public Resources aggregate(File resourcesXml, File outputBaseDirectory) throws IOException, AggregationException {
        Js lastJsAggregate;
        Css lastCssAggregate;
        if (null == outputBaseDirectory || !outputBaseDirectory.isDirectory() || !outputBaseDirectory.canWrite()) {
            throw new IllegalArgumentException("outputBaseDirectory (" + (null == outputBaseDirectory ? null : outputBaseDirectory.getAbsolutePath()) + ") must be a directory AND writable");
        }
        Resources original = this.loadResourcesXml(resourcesXml);
        File resourcesParentDir = resourcesXml.getParentFile();
        String resourcesXmlBaseName = FilenameUtils.getBaseName((String)resourcesXml.getName());
        ArrayList<Css> cssResult = new ArrayList<Css>();
        ArrayList<Css> currentCssAggregateList = new ArrayList<Css>();
        int aggregateIndex = 1;
        for (Css originalCssElement : original.getCss()) {
            if (currentCssAggregateList.isEmpty()) {
                currentCssAggregateList.add(originalCssElement);
                continue;
            }
            if (originalCssElement.willAggregateWith((Css)currentCssAggregateList.get(0))) {
                currentCssAggregateList.add(originalCssElement);
                continue;
            }
            Css aggregate = this.aggregateCssList(currentCssAggregateList, aggregateIndex++, resourcesParentDir, outputBaseDirectory);
            cssResult.add(aggregate);
            currentCssAggregateList = new ArrayList();
            currentCssAggregateList.add(originalCssElement);
        }
        if (null != (lastCssAggregate = this.aggregateCssList(currentCssAggregateList, aggregateIndex++, resourcesParentDir, outputBaseDirectory))) {
            cssResult.add(lastCssAggregate);
        }
        ArrayList<Js> jsResult = new ArrayList<Js>();
        ArrayList<Js> currentJsAggregateList = new ArrayList<Js>();
        for (Js originalJsElement : original.getJs()) {
            if (currentJsAggregateList.isEmpty()) {
                currentJsAggregateList.add(originalJsElement);
                continue;
            }
            if (originalJsElement.willAggregateWith((Js)currentJsAggregateList.get(0))) {
                currentJsAggregateList.add(originalJsElement);
                continue;
            }
            Js aggregate = this.aggregateJsList(currentJsAggregateList, aggregateIndex++, resourcesParentDir, outputBaseDirectory);
            jsResult.add(aggregate);
            currentJsAggregateList = new ArrayList();
            currentJsAggregateList.add(originalJsElement);
        }
        if (null != (lastJsAggregate = this.aggregateJsList(currentJsAggregateList, aggregateIndex++, resourcesParentDir, outputBaseDirectory))) {
            jsResult.add(lastJsAggregate);
        }
        Resources aggregatedForm = new Resources();
        aggregatedForm.getCss().addAll(cssResult);
        aggregatedForm.getJs().addAll(jsResult);
        StringBuilder aggregatedFormOutputFileName = new StringBuilder();
        aggregatedFormOutputFileName.append("uportal3_aggr");
        aggregatedFormOutputFileName.append(".").append(resourcesXmlBaseName);
        aggregatedFormOutputFileName.append(".").append(FilenameUtils.getExtension((String)resourcesXml.getName()));
        File aggregatedOutputFile = new File(outputBaseDirectory, aggregatedFormOutputFileName.toString());
        this.writeResourcesXmlToFile(aggregatedForm, aggregatedOutputFile);
        return aggregatedForm;
    }

    protected Resources loadResourcesXml(File resourcesXml) throws AggregationException {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"org.jasig.portal.web.skin");
            Unmarshaller u = context.createUnmarshaller();
            Resources result = (Resources)u.unmarshal(resourcesXml);
            return result;
        }
        catch (JAXBException e) {
            throw new AggregationException("an error occurred loading " + resourcesXml, e);
        }
    }

    protected void writeResourcesXmlToFile(Resources resources, File file) throws AggregationException {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"org.jasig.portal.web.skin");
            Marshaller m = context.createMarshaller();
            m.marshal((Object)resources, file);
        }
        catch (JAXBException e) {
            throw new AggregationException("an error writing resources to file " + file, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Css aggregateCssList(List<Css> elements, int aggregateIndex, File skinDirectory, File outputRoot) throws IOException {
        if (null == elements || elements.size() == 0) {
            return null;
        }
        Css headElement = elements.get(0);
        if (elements.size() == 1 && headElement.isAbsolute()) {
            return headElement;
        }
        String cssElementRelativePath = FilenameUtils.getFullPath((String)headElement.getValue());
        File cssDirectoryInOutputRoot = this.resolvePath(outputRoot, cssElementRelativePath);
        cssDirectoryInOutputRoot.mkdirs();
        File tempFile = new File(cssDirectoryInOutputRoot, AGGREGATE_FILE_PREFIX + aggregateIndex + "_temp" + CSS);
        FileOutputStream out = new FileOutputStream(tempFile);
        for (Css css : elements) {
            File cssFile = this.resolvePath(skinDirectory, css.getValue());
            FileInputStream cssIn = new FileInputStream(cssFile);
            try {
                IOUtils.copy((InputStream)cssIn, (OutputStream)out);
                IOUtils.write((String)SystemUtils.LINE_SEPARATOR, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)cssIn);
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        String checksum = this.checksum(tempFile);
        String newFileName = this.buildAggregateFileName(aggregateIndex, checksum, CSS);
        File aggregateOutputFile = new File(cssDirectoryInOutputRoot, newFileName);
        aggregateOutputFile.delete();
        FileWriter compressWriter = new FileWriter(aggregateOutputFile);
        FileReader tempFileReader = new FileReader(tempFile);
        CssCompressor cssCompressor = new CssCompressor((Reader)tempFileReader);
        try {
            cssCompressor.compress((Writer)compressWriter, this.cssLineBreakColumnNumber);
        }
        finally {
            IOUtils.closeQuietly((Reader)tempFileReader);
            IOUtils.closeQuietly((Writer)compressWriter);
        }
        tempFile.delete();
        Css result = new Css();
        StringBuilder newResultValue = new StringBuilder();
        if (StringUtils.isNotBlank((String)cssElementRelativePath)) {
            newResultValue.append(cssElementRelativePath);
            if (!cssElementRelativePath.endsWith("/")) {
                newResultValue.append("/");
            }
        }
        newResultValue.append(newFileName);
        result.setValue(newResultValue.toString());
        result.setConditional(headElement.getConditional());
        result.setMedia(headElement.getMedia());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Js aggregateJsList(List<Js> elements, int aggregateIndex, File skinDirectory, File outputRoot) throws IOException {
        if (null == elements || elements.size() == 0) {
            return null;
        }
        Js headElement = elements.get(0);
        if (elements.size() == 1 && (headElement.isAbsolute() || headElement.isCompressed())) {
            return headElement;
        }
        String jsElementRelativePath = FilenameUtils.getFullPath((String)headElement.getValue());
        File jsDirectoryInOutputRoot = this.resolvePath(outputRoot, jsElementRelativePath);
        jsDirectoryInOutputRoot.mkdirs();
        File tempFile = new File(jsDirectoryInOutputRoot, AGGREGATE_FILE_PREFIX + aggregateIndex + "_temp" + JS);
        FileOutputStream out = new FileOutputStream(tempFile);
        for (Js js : elements) {
            File originalJsFile = this.resolvePath(skinDirectory, js.getValue());
            if (!js.isCompressed()) {
                InputStreamReader originalJsFileReader = new InputStreamReader(new FileInputStream(originalJsFile));
                File compressedJsFile = new File(jsDirectoryInOutputRoot, originalJsFile.getName() + ".tmp");
                FileWriter compressWriter = new FileWriter(compressedJsFile);
                JavaScriptCompressor jsCompressor = new JavaScriptCompressor((Reader)originalJsFileReader, (ErrorReporter)new JavaScriptErrorReporterImpl());
                try {
                    jsCompressor.compress((Writer)compressWriter, this.jsLineBreakColumnNumber, this.obfuscateJs, this.displayJsWarnings, this.preserveAllSemiColons, this.disableJsOptimizations);
                }
                finally {
                    IOUtils.closeQuietly((Reader)originalJsFileReader);
                    IOUtils.closeQuietly((Writer)compressWriter);
                }
                FileInputStream jsIn = new FileInputStream(compressedJsFile);
                try {
                    IOUtils.copy((InputStream)jsIn, (OutputStream)out);
                    IOUtils.write((String)SystemUtils.LINE_SEPARATOR, (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)jsIn);
                }
                compressedJsFile.delete();
                continue;
            }
            FileInputStream jsIn = new FileInputStream(originalJsFile);
            try {
                IOUtils.copy((InputStream)jsIn, (OutputStream)out);
                IOUtils.write((String)SystemUtils.LINE_SEPARATOR, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)jsIn);
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        String checksum = this.checksum(tempFile);
        String newFileName = this.buildAggregateFileName(aggregateIndex, checksum, JS);
        File aggregateOutputFile = new File(jsDirectoryInOutputRoot, newFileName);
        aggregateOutputFile.delete();
        FileUtils.moveFile((File)tempFile, (File)aggregateOutputFile);
        StringBuilder newResultValue = new StringBuilder();
        if (StringUtils.isNotBlank((String)jsElementRelativePath)) {
            newResultValue.append(jsElementRelativePath);
            if (!jsElementRelativePath.endsWith("/")) {
                newResultValue.append("/");
            }
        }
        newResultValue.append(newFileName);
        Js result = new Js();
        result.setValue(newResultValue.toString());
        result.setConditional(headElement.getConditional());
        result.setCompressed(headElement.isCompressed());
        return result;
    }

    protected String buildAggregateFileName(int aggregateIndex, String checksum, String suffix) {
        StringBuilder result = new StringBuilder(AGGREGATE_FILE_PREFIX);
        result.append(aggregateIndex);
        result.append("_");
        result.append(checksum);
        result.append(suffix);
        return result.toString();
    }

    protected File resolvePath(File directory, String path) {
        File resolved = new File(directory, path);
        return resolved;
    }

    protected String checksum(File file) throws IOException {
        try {
            int read;
            FileInputStream fin = new FileInputStream(file);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            do {
                if ((read = ((InputStream)fin).read(buffer)) <= 0) continue;
                md5.update(buffer, 0, read);
            } while (read != -1);
            ((InputStream)fin).close();
            byte[] digest = md5.digest();
            if (digest == null) {
                return null;
            }
            StringBuilder strDigest = new StringBuilder();
            for (int i = 0; i < digest.length; ++i) {
                strDigest.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1).toUpperCase());
            }
            return strDigest.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("NoSuchAlgorithmException thrown when trying to initialize MD5", e);
        }
    }

    protected static class JavaScriptErrorReporterImpl
    implements ErrorReporter {
        protected JavaScriptErrorReporterImpl() {
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            StringBuilder mesg = new StringBuilder("JavaScriptCompressor ERROR, ");
            mesg.append("message: ").append(message);
            mesg.append(", sourceName: ").append(sourceName);
            mesg.append(", line: ").append(line);
            mesg.append(", lineSource: ").append(lineSource);
            mesg.append(", lineOffset: ").append(lineOffset);
            LOG.error((Object)mesg);
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            StringBuilder mesg = new StringBuilder("JavaScriptCompressor WARNING, ");
            mesg.append("message: ").append(message);
            mesg.append(", sourceName: ").append(sourceName);
            mesg.append(", line: ").append(line);
            mesg.append(", lineSource: ").append(lineSource);
            mesg.append(", lineOffset: ").append(lineOffset);
            LOG.warn((Object)mesg);
        }
    }
}

