/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.plugin.mojo;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.BuildException;
import org.jasig.portal.plugin.deployer.config.TomcatDeployerConfig;
import org.jasig.portal.plugin.deployer.config.TomcatEarDeployer;
import org.jasig.portal.plugin.mojo.AbstractTomcatMojo;

public class DeployEarMojo
extends AbstractTomcatMojo {
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private String artifactId;
    private String artifactGroupId;
    private String artifactVersion;
    private String artifactClassifier;
    private File ear;
    private boolean extractWars = false;
    private boolean removeExistingDirectories = false;

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public ArtifactResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ArtifactResolver resolver) {
        this.resolver = resolver;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(List remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getArtifactGroupId() {
        return this.artifactGroupId;
    }

    public void setArtifactGroupId(String artifactGroupId) {
        this.artifactGroupId = artifactGroupId;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public String getArtifactClassifier() {
        return this.artifactClassifier;
    }

    public void setArtifactClassifier(String artifactClassifier) {
        this.artifactClassifier = artifactClassifier;
    }

    public File getEar() {
        return this.ear;
    }

    public void setEar(File ear) {
        this.ear = ear;
    }

    public boolean isExtractWars() {
        return this.extractWars;
    }

    public void setExtractWars(boolean extractWars) {
        this.extractWars = extractWars;
    }

    public boolean isRemoveExistingDirectories() {
        return this.removeExistingDirectories;
    }

    public void setRemoveExistingDirectories(boolean removeExistingDirectories) {
        this.removeExistingDirectories = removeExistingDirectories;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        TomcatDeployerConfig config = new TomcatDeployerConfig();
        File fullJarDir = new File(this.getJarDir());
        config.setJarDir(fullJarDir);
        File fullWebAppsDir = new File(this.getWebAppsDir());
        config.setWebAppsDir(fullWebAppsDir);
        this.getLog().info((CharSequence)("Using classifier: " + this.artifactClassifier));
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.artifactGroupId, this.artifactId, this.artifactVersion, "ear", this.artifactClassifier);
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            File artifactFile = artifact.getFile();
            config.setEarLocation(artifactFile);
        }
        catch (ArtifactResolutionException ex) {
            this.getLog().error((CharSequence)"Failed to resolve artifact", (Throwable)ex);
            throw new MojoFailureException("Failed to resolve artifact " + artifact);
        }
        catch (ArtifactNotFoundException ex) {
            this.getLog().error((CharSequence)"Failed to find artifact", (Throwable)ex);
            throw new MojoFailureException("Failed to find artifact " + artifact);
        }
        config.setExtractWars(this.isExtractWars());
        config.setRemoveExistingDirectories(this.isRemoveExistingDirectories());
        TomcatEarDeployer deployer = new TomcatEarDeployer();
        try {
            deployer.deployEar(config);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

