/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.plugin.mojo;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.jasig.portal.plugin.mojo.AbstractTomcatMojo;

public abstract class AbstractTomcatWarDeployerMojo
extends AbstractTomcatMojo {
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver resolver;
    protected ArtifactRepository localRepository;
    protected List remoteRepositories;
    protected ArchiverManager archiverManager;

    protected void extractWar(File warfile, File contextDirectory, String contextName) throws NoSuchArchiverException, ArchiverException, IOException {
        this.getLog().info((CharSequence)("Extracting war for context " + contextName));
        UnArchiver unArchiver = this.archiverManager.getUnArchiver("war");
        unArchiver.setSourceFile(warfile);
        unArchiver.setDestDirectory(contextDirectory);
        unArchiver.setOverwrite(true);
        unArchiver.extract();
    }

    protected void removeExisting(File dir, String contextName) {
        try {
            File warFile;
            File contextDir = new File(dir, contextName);
            if (contextDir.exists()) {
                FileUtils.deleteDirectory((File)contextDir);
            }
            if ((warFile = new File(dir, contextName.concat(".war"))).exists()) {
                warFile.delete();
            }
        }
        catch (IOException ex) {
            this.getLog().warn((CharSequence)"Error deleting existing item", (Throwable)ex);
        }
    }
}

