/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.plugin.deployer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.plugin.deployer.ClasspathEntityResolver;
import org.jasig.portal.plugin.deployer.DeployerConfig;
import org.jasig.portal.plugin.deployer.WebModule;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEarDeployer<CONFIG extends DeployerConfig> {
    private static final String DESCRIPTOR_PATH = "META-INF/application.xml";
    private static final String WEB_MODULE_XPATH = "//application/module/web";
    private static final String WEB_URI_NODE_NAME = "web-uri";
    private static final String CONTEXT_ROOT_NODE_NAME = "context-root";
    protected final Log logger = LogFactory.getLog(this.getClass());

    public final void deployEar(CONFIG deployerConfig) throws IOException {
        JarFile earFile = this.getEarFile((DeployerConfig)deployerConfig);
        Document descriptorDom = this.getDescriptorDom(earFile);
        NodeList webModules = this.getWebModules(descriptorDom);
        for (int index = 0; index < webModules.getLength(); ++index) {
            Node webModuleNode = webModules.item(index);
            WebModule webModuleInfo = this.getWebModuleInfo(webModuleNode);
            this.deployWar(webModuleInfo, earFile, deployerConfig);
        }
        Enumeration<JarEntry> earEntries = earFile.entries();
        while (earEntries.hasMoreElements()) {
            JarEntry entry = earEntries.nextElement();
            if (!entry.getName().endsWith(".jar")) continue;
            this.deployJar(entry, earFile, deployerConfig);
        }
    }

    protected abstract void deployWar(WebModule var1, JarFile var2, CONFIG var3) throws IOException;

    protected abstract void deployJar(JarEntry var1, JarFile var2, CONFIG var3) throws IOException;

    protected JarFile getEarFile(DeployerConfig deployerConfig) throws IOException {
        JarFile earFile = new JarFile(deployerConfig.getEarLocation());
        return earFile;
    }

    protected Document getDescriptorDom(JarFile earFile) throws IOException {
        ZipEntry descriptorEntry = earFile.getEntry(DESCRIPTOR_PATH);
        if (descriptorEntry == null) {
            throw new IllegalArgumentException("JarFile '" + earFile + "' does not contain a descriptor at '" + DESCRIPTOR_PATH + "'");
        }
        InputStream descriptorStream = earFile.getInputStream(descriptorEntry);
        try {
            DocumentBuilder docBuilder;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                docBuilder = docBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                throw new RuntimeException("Failed to create DocumentBuilder to parse EAR descriptor.", pce);
            }
            docBuilder.setEntityResolver(new ClasspathEntityResolver());
            try {
                Document descriptorDom;
                Document document = descriptorDom = docBuilder.parse(descriptorStream);
                return document;
            }
            catch (SAXException e) {
                throw new RuntimeException("Failed to parse descriptor 'META-INF/application.xml' from EAR '" + earFile.getName() + "'", e);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)descriptorStream);
        }
    }

    protected NodeList getWebModules(Document descriptorDom) {
        XPathExpression xpathExpr;
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        try {
            xpathExpr = xpath.compile(WEB_MODULE_XPATH);
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException("Failed to compile XPathExpression from '//application/module/web'", xpee);
        }
        try {
            NodeList nodes = (NodeList)xpathExpr.evaluate(descriptorDom, XPathConstants.NODESET);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found " + nodes.getLength() + " '" + WEB_MODULE_XPATH + "' nodes in descriptor."));
            }
            return nodes;
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException("Failed to evaluate XPathExpression='" + xpathExpr + "'", xpee);
        }
    }

    protected WebModule getWebModuleInfo(Node webModuleNode) {
        if (!"web".equals(this.getNodeName(webModuleNode))) {
            throw new IllegalArgumentException("webModuleNode must be a 'web' Node");
        }
        String webUri = null;
        String contextRoot = null;
        NodeList childNodes = webModuleNode.getChildNodes();
        for (int index = 0; index < childNodes.getLength() && (webUri == null || contextRoot == null); ++index) {
            Node node = childNodes.item(index);
            String nodeName = this.getNodeName(node);
            if (WEB_URI_NODE_NAME.equals(nodeName)) {
                webUri = StringUtils.strip((String)node.getTextContent());
                continue;
            }
            if (!CONTEXT_ROOT_NODE_NAME.equals(nodeName)) continue;
            contextRoot = StringUtils.strip((String)node.getTextContent());
        }
        if (webUri == null || contextRoot == null) {
            throw new IllegalArgumentException("Node '" + webModuleNode + "' did not contain the nessesary information to create a WebModule. webUri='" + webUri + "', contextRoot='" + contextRoot + "'");
        }
        WebModule webModule = new WebModule();
        webModule.setWebUri(webUri);
        webModule.setContextRoot(contextRoot);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found WebModule='" + webModule + "'"));
        }
        return webModule;
    }

    protected File createSafeFile(File baseDir, String fileName) throws IOException {
        File safeFile = new File(baseDir, fileName);
        if (safeFile.exists()) {
            safeFile.delete();
        } else {
            FileUtils.forceMkdir((File)baseDir);
        }
        return safeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyAndClose(JarEntry earEntry, JarFile earFile, File destinationFile) throws IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Copying EAR entry '" + earFile.getName() + "!" + earEntry.getName() + "' to '" + destinationFile + "'"));
        }
        InputStream jarEntryStream = earFile.getInputStream(earEntry);
        try {
            FileOutputStream jarOutStream = new FileOutputStream(destinationFile);
            try {
                IOUtils.copy((InputStream)jarEntryStream, (OutputStream)jarOutStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)jarOutStream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)jarEntryStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractWar(JarFile earFile, JarEntry earEntry, File contextDir) throws IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Extracting EAR entry '" + earFile.getName() + "!" + earEntry.getName() + "' to '" + contextDir + "'"));
        }
        if (!contextDir.exists()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating context directory entry '" + contextDir + "'"));
            }
            FileUtils.forceMkdir((File)contextDir);
        }
        JarInputStream warInputStream = new JarInputStream(earFile.getInputStream(earEntry));
        try {
            JarEntry warEntry;
            while ((warEntry = warInputStream.getNextJarEntry()) != null) {
                File warEntryFile = new File(contextDir, warEntry.getName());
                if (warEntry.isDirectory()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Creating WAR directory entry '" + earEntry.getName() + "!" + warEntry.getName() + "' as '" + warEntryFile + "'"));
                    }
                    FileUtils.forceMkdir((File)warEntryFile);
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Extracting WAR entry '" + earEntry.getName() + "!" + warEntry.getName() + "' to '" + warEntryFile + "'"));
                }
                FileUtils.forceMkdir((File)warEntryFile.getParentFile());
                FileOutputStream jarEntryFileOutputStream = new FileOutputStream(warEntryFile);
                try {
                    IOUtils.copy((InputStream)warInputStream, (OutputStream)jarEntryFileOutputStream);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)jarEntryFileOutputStream);
                }
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)warInputStream);
        }
    }

    private String getNodeName(Node node) {
        if (node.getNamespaceURI() == null) {
            return node.getNodeName();
        }
        return node.getLocalName();
    }
}

