/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.tomcat.v7;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.session.SingleSignOutHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleSignOutValve
extends ValveBase
implements SessionListener {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SingleSignOutHandler handler = new SingleSignOutHandler();

    public void setArtifactParameterName(String name) {
        this.handler.setArtifactParameterName(name);
    }

    public void setLogoutParameterName(String name) {
        this.handler.setLogoutParameterName(name);
    }

    public void setFrontLogoutParameterName(String name) {
        this.handler.setFrontLogoutParameterName(name);
    }

    public void setRelayStateParameterName(String name) {
        this.handler.setRelayStateParameterName(name);
    }

    public void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.handler.setCasServerUrlPrefix(casServerUrlPrefix);
    }

    public void setSessionMappingStorage(SessionMappingStorage storage) {
        this.handler.setSessionMappingStorage(storage);
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.handler.process((HttpServletRequest)request, (HttpServletResponse)response)) {
            this.getNext().invoke(request, response);
        }
    }

    public void sessionEvent(SessionEvent event) {
        if ("destroySession".equals(event.getType())) {
            this.logger.debug("Cleaning up SessionMappingStorage on destroySession event");
            this.handler.getSessionMappingStorage().removeBySessionById(event.getSession().getId());
        }
    }

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        this.logger.info("Starting...");
        this.handler.init();
        this.logger.info("Startup completed.");
    }
}

