/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.Closeable;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.management.MBeanServerConnection;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.DefaultExitHandler;
import org.infinispan.server.ExitHandler;
import org.infinispan.server.ExitStatus;
import org.infinispan.server.Server;
import org.infinispan.server.test.core.AbstractInfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;

public class EmbeddedInfinispanServerDriver
extends AbstractInfinispanServerDriver {
    public static final int OFFSET_FACTOR = 100;
    private static final int TIMEOUT_SECONDS = Integer.getInteger("org.infinispan.test.server.embedded.timeoutSeconds", 30);
    List<Server> servers;
    List<CompletableFuture<ExitStatus>> serverFutures;

    protected EmbeddedInfinispanServerDriver(InfinispanServerTestConfiguration configuration) {
        super(configuration, InetAddress.getLoopbackAddress());
        System.setProperty("infinispan.security.elytron.nonceshutdown", "false");
    }

    protected int clusterPortOffset() {
        return this.configuration.site() == null ? this.configuration.getPortOffset() : this.configuration.sitePortOffset();
    }

    @Override
    protected void start(String name, File rootDir, File configurationFile) {
        if (this.configuration.archives() != null && this.configuration.archives().length > 0 || this.configuration.mavenArtifacts() != null && this.configuration.mavenArtifacts().length > 0) {
            throw new IllegalArgumentException("EmbeddedInfinispanServerDriver doesn't support server artifacts.");
        }
        this.servers = new ArrayList<Server>();
        this.serverFutures = new ArrayList<CompletableFuture<ExitStatus>>();
        for (int i = 0; i < this.configuration.numServers(); ++i) {
            File serverRoot = EmbeddedInfinispanServerDriver.createServerHierarchy(rootDir, Integer.toString(i));
            this.copyArtifactsToDataDir();
            Server server = this.createServerInstance(name, rootDir, configurationFile, i, serverRoot);
            this.serverFutures.add(server.run());
            this.servers.add(server);
        }
        List<EmbeddedCacheManager> cacheManagers = this.servers.stream().map(Server::getCacheManager).collect(Collectors.toList());
        if (cacheManagers.size() > 1) {
            EmbeddedInfinispanServerDriver.blockUntilViewsReceived(cacheManagers);
        }
    }

    private Server createServerInstance(String name, File rootDir, File configurationFile, int serverIndex, File serverRoot) {
        Properties properties = new Properties();
        properties.setProperty("infinispan.server.home.path", serverRoot.getAbsolutePath());
        properties.setProperty("infinispan.server.config.path", new File(rootDir, "conf").getAbsolutePath());
        properties.setProperty("infinispan.socket.binding.port-offset", Integer.toString(this.clusterPortOffset() + serverIndex * 100));
        properties.setProperty("infinispan.cluster.name", name);
        properties.setProperty("infinispan.cluster.stack", System.getProperty("infinispan.cluster.stack"));
        properties.setProperty("org.infinispan.test.host.address", this.testHostAddress.getHostName());
        properties.setProperty("infinispan.server.log4j.shutdown", "false");
        if (serverIndex == 0 && this.configuration.site() == null) {
            properties.setProperty("jgroups.join_timeout", "0");
        }
        this.configureSite(properties);
        this.configuration.properties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String value = StringPropertyReplacer.replaceProperties((String)((String)v), (Properties)properties);
            properties.put(k, value);
            System.setProperty(k.toString(), value);
        }));
        Server server = new Server(serverRoot, new File(configurationFile.getName()), properties);
        server.setExitHandler((ExitHandler)new DefaultExitHandler());
        return server;
    }

    @Override
    protected void stop() {
        RuntimeException aggregate = new RuntimeException();
        if (this.servers != null) {
            for (int i = 0; i < this.servers.size(); ++i) {
                try {
                    this.stop(i);
                    continue;
                }
                catch (Throwable e) {
                    aggregate.addSuppressed(e.getCause());
                }
            }
            if (aggregate.getSuppressed().length > 0) {
                throw aggregate;
            }
        }
    }

    @Override
    public InetSocketAddress getServerSocket(int serverIndex, int port) {
        return new InetSocketAddress("127.0.0.1", port + this.clusterPortOffset() + serverIndex * 100);
    }

    @Override
    public InetAddress getServerAddress(int serverIndex) {
        return (InetAddress)Exceptions.unchecked(() -> InetAddress.getByName("127.0.0.1"));
    }

    @Override
    public void pause(int serverIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resume(int serverIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop(int serverIndex) {
        try {
            Server server = this.servers.get(serverIndex);
            if (server == null) {
                return;
            }
            server.getExitHandler().exit(ExitStatus.SERVER_SHUTDOWN);
            this.serverFutures.get(serverIndex).get();
            this.serverFutures.set(serverIndex, null);
            this.servers.set(serverIndex, null);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot stop the server: " + serverIndex, t);
        }
    }

    @Override
    public void kill(int serverIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restart(int serverIndex) {
        assert (!this.isRunning(serverIndex));
        File serverRoot = EmbeddedInfinispanServerDriver.serverRoot(this.getRootDir(), Integer.toString(serverIndex));
        Server server = this.createServerInstance(this.getName(), this.getRootDir(), new File(this.configuration.configurationFile()), serverIndex, serverRoot);
        this.servers.set(serverIndex, server);
        this.serverFutures.set(serverIndex, server.run());
    }

    @Override
    public void restartCluster() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRunning(int serverIndex) {
        Server server = this.servers.get(serverIndex);
        return server != null && server.getStatus().allowInvocations();
    }

    @Override
    public MBeanServerConnection getJmxConnection(int server, String username, String password, Consumer<Closeable> reaper) {
        DefaultCacheManager cacheManager = this.servers.get(server).getCacheManager();
        return cacheManager.getCacheManagerConfiguration().jmx().mbeanServerLookup().getMBeanServer();
    }

    @Override
    public int getTimeout() {
        return TIMEOUT_SECONDS;
    }

    private void configureSite(Properties properties) {
        if (this.configuration.site() == null) {
            return;
        }
        properties.setProperty("relay.site_name", this.configuration.site());
        properties.setProperty("jgroups.cluster.mcast_port", Integer.toString(this.configuration.siteDiscoveryPort()));
        properties.setProperty("jgroups.tcp.port", Integer.toString(7800 + this.clusterPortOffset()));
    }

    private static void blockUntilViewsReceived(List<EmbeddedCacheManager> cacheManagers) {
        long failTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(TIMEOUT_SECONDS);
        while (System.currentTimeMillis() < failTime) {
            if (EmbeddedInfinispanServerDriver.areCacheViewsComplete(cacheManagers, false)) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        EmbeddedInfinispanServerDriver.areCacheViewsComplete(cacheManagers, true);
    }

    public static boolean areCacheViewsComplete(List<EmbeddedCacheManager> cacheManagers, boolean fail) {
        int memberCount = cacheManagers.size();
        for (EmbeddedCacheManager manager : cacheManagers) {
            if (EmbeddedInfinispanServerDriver.isCacheViewComplete(manager.getMembers(), manager.getAddress(), memberCount, fail)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCacheViewComplete(List<Address> members, Address address, int memberCount, boolean fail) {
        if (members == null || memberCount > members.size()) {
            if (fail) {
                if (members == null) {
                    throw new IllegalStateException("Member " + String.valueOf(address) + " is not connected yet!");
                }
                EmbeddedInfinispanServerDriver.failMissingMembers(members, address, memberCount);
            }
            return false;
        }
        if (memberCount < members.size()) {
            EmbeddedInfinispanServerDriver.failMissingMembers(members, address, memberCount);
        }
        return true;
    }

    private static void failMissingMembers(List<Address> members, Address address, int memberCount) {
        StringBuilder sb = new StringBuilder("Cache at address ");
        sb.append(address);
        sb.append(" had ");
        sb.append(members.size());
        sb.append(" members; expecting ");
        sb.append(memberCount);
        sb.append(". Members were (");
        for (int j = 0; j < members.size(); ++j) {
            if (j > 0) {
                sb.append(", ");
            }
            sb.append(members.get(j));
        }
        sb.append(')');
        throw new IllegalStateException(sb.toString());
    }

    @Override
    public String syncFilesFromServer(int server, String dir) {
        return this.getRootDir().toPath().resolve(Integer.toString(server)).toString();
    }

    @Override
    public String syncFilesToServer(int server, String path) {
        return path;
    }
}

