/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.tm;

import java.io.Serializable;
import java.util.UUID;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DummyBaseTransactionManager
implements TransactionManager,
Serializable {
    static ThreadLocal<DummyTransaction> thread_local = new ThreadLocal();
    private static final long serialVersionUID = -6716097342564237376L;
    private static final Log log = LogFactory.getLog(DummyBaseTransactionManager.class);
    private static final boolean trace = log.isTraceEnabled();
    final UUID transactionManagerId = UUID.randomUUID();
    private boolean useXaXid = false;

    public void begin() throws NotSupportedException, SystemException {
        DummyTransaction currentTx = this.getTransaction();
        if (currentTx != null) {
            throw new NotSupportedException(Thread.currentThread() + " is already associated with a transaction (" + currentTx + ")");
        }
        DummyTransaction tx = new DummyTransaction(this);
        DummyBaseTransactionManager.setTransaction(tx);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        DummyTransaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("thread not associated with transaction");
        }
        int status = tx.getStatus();
        if (status == 1) {
            tx.setStatus(4);
            this.rollback();
            throw new RollbackException("Transaction status is Status.STATUS_MARKED_ROLLBACK");
        }
        tx.commit();
        DummyBaseTransactionManager.setTransaction(null);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        DummyTransaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("no transaction associated with thread");
        }
        tx.rollback();
        DummyBaseTransactionManager.setTransaction(null);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        DummyTransaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("no transaction associated with calling thread");
        }
        tx.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        DummyTransaction tx = this.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    public DummyTransaction getTransaction() {
        return thread_local.get();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        throw new SystemException("not supported");
    }

    public Transaction suspend() throws SystemException {
        DummyTransaction retval = this.getTransaction();
        DummyBaseTransactionManager.setTransaction(null);
        if (trace) {
            log.tracef("Suspending tx %s", retval);
        }
        return retval;
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (trace) {
            log.tracef("Resuming tx %s", tx);
        }
        DummyBaseTransactionManager.setTransaction(tx);
    }

    public static void setTransaction(Transaction tx) {
        thread_local.set((DummyTransaction)tx);
    }

    public final boolean isUseXaXid() {
        return this.useXaXid;
    }

    public final void setUseXaXid(boolean useXaXid) {
        this.useXaXid = useXaXid;
    }
}

