/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.event;

import java.util.Collection;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.Cache;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryLoadedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.Util;

@NotThreadSafe
public class EventImpl<K, V>
implements CacheEntryActivatedEvent,
CacheEntryCreatedEvent,
CacheEntriesEvictedEvent,
CacheEntryLoadedEvent,
CacheEntryModifiedEvent,
CacheEntryPassivatedEvent,
CacheEntryRemovedEvent,
CacheEntryVisitedEvent,
TransactionCompletedEvent,
TransactionRegisteredEvent,
CacheEntryInvalidatedEvent,
DataRehashedEvent,
TopologyChangedEvent,
CacheEntryEvictedEvent {
    private boolean pre = false;
    private Cache<K, V> cache;
    private K key;
    private GlobalTransaction transaction;
    private boolean originLocal = true;
    private boolean transactionSuccessful;
    private Event.Type type;
    private V value;
    private Collection<Address> membersAtStart;
    private Collection<Address> membersAtEnd;
    private ConsistentHash consistentHashAtStart;
    private ConsistentHash consistentHashAtEnd;
    private long newViewId;
    private Map<Object, Object> entries;

    public static <K, V> EventImpl<K, V> createEvent(Cache<K, V> cache, Event.Type type) {
        EventImpl<K, V> e = new EventImpl<K, V>();
        e.cache = cache;
        e.type = type;
        return e;
    }

    @Override
    public Event.Type getType() {
        return this.type;
    }

    @Override
    public boolean isPre() {
        return this.pre;
    }

    @Override
    public Cache<K, V> getCache() {
        return this.cache;
    }

    @Override
    public K getKey() {
        if (this.key instanceof MarshalledValue) {
            this.key = ((MarshalledValue)this.key).get();
        }
        return this.key;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.transaction;
    }

    @Override
    public boolean isOriginLocal() {
        return this.originLocal;
    }

    @Override
    public boolean isTransactionSuccessful() {
        return this.transactionSuccessful;
    }

    public void setPre(boolean pre) {
        this.pre = pre;
    }

    public void setCache(Cache<K, V> cache) {
        this.cache = cache;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public void setTransactionId(GlobalTransaction transaction) {
        this.transaction = transaction;
    }

    public void setOriginLocal(boolean originLocal) {
        this.originLocal = originLocal;
    }

    public void setTransactionSuccessful(boolean transactionSuccessful) {
        this.transactionSuccessful = transactionSuccessful;
    }

    public void setType(Event.Type type) {
        this.type = type;
    }

    public void setMembersAtStart(Collection<Address> membersAtStart) {
        this.membersAtStart = membersAtStart;
    }

    public void setMembersAtEnd(Collection<Address> membersAtEnd) {
        this.membersAtEnd = membersAtEnd;
    }

    public void setConsistentHashAtStart(ConsistentHash consistentHashAtStart) {
        this.consistentHashAtStart = consistentHashAtStart;
    }

    public void setConsistentHashAtEnd(ConsistentHash consistentHashAtEnd) {
        this.consistentHashAtEnd = consistentHashAtEnd;
    }

    public void setNewViewId(long newViewId) {
        this.newViewId = newViewId;
    }

    @Override
    public V getValue() {
        if (this.value instanceof MarshalledValue) {
            this.value = ((MarshalledValue)this.value).get();
        }
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public void setEntries(Map<Object, Object> entries) {
        this.entries = entries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventImpl event = (EventImpl)o;
        if (this.originLocal != event.originLocal) {
            return false;
        }
        if (this.pre != event.pre) {
            return false;
        }
        if (this.transactionSuccessful != event.transactionSuccessful) {
            return false;
        }
        if (this.cache != null ? !this.cache.equals(event.cache) : event.cache != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(event.key) : event.key != null) {
            return false;
        }
        if (this.transaction != null ? !this.transaction.equals(event.transaction) : event.transaction != null) {
            return false;
        }
        if (this.type != event.type) {
            return false;
        }
        if (this.value != null ? !this.value.equals(event.value) : event.value != null) {
            return false;
        }
        if (!Util.safeEquals(this.consistentHashAtStart, event.consistentHashAtStart)) {
            return false;
        }
        if (!Util.safeEquals(this.consistentHashAtEnd, event.consistentHashAtEnd)) {
            return false;
        }
        if (!Util.safeEquals(this.membersAtStart, event.membersAtStart)) {
            return false;
        }
        if (!Util.safeEquals(this.membersAtEnd, event.membersAtEnd)) {
            return false;
        }
        return this.newViewId == event.newViewId;
    }

    public int hashCode() {
        int result = this.pre ? 1 : 0;
        result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.transaction != null ? this.transaction.hashCode() : 0);
        result = 31 * result + (this.originLocal ? 1 : 0);
        result = 31 * result + (this.transactionSuccessful ? 1 : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.membersAtStart != null ? ((Object)this.membersAtStart).hashCode() : 0);
        result = 31 * result + (this.membersAtEnd != null ? ((Object)this.membersAtEnd).hashCode() : 0);
        result = 31 * result + (this.consistentHashAtStart != null ? this.consistentHashAtStart.hashCode() : 0);
        result = 31 * result + (this.consistentHashAtEnd != null ? this.consistentHashAtEnd.hashCode() : 0);
        result = 31 * result + (int)this.newViewId;
        return result;
    }

    public String toString() {
        return "EventImpl{pre=" + this.pre + ", key=" + this.key + ", transaction=" + this.transaction + ", originLocal=" + this.originLocal + ", transactionSuccessful=" + this.transactionSuccessful + ", type=" + (Object)((Object)this.type) + ", value=" + this.value + '}';
    }

    @Override
    public Collection<Address> getMembersAtStart() {
        return this.membersAtStart;
    }

    @Override
    public Collection<Address> getMembersAtEnd() {
        return this.membersAtEnd;
    }

    @Override
    public long getNewViewId() {
        return this.newViewId;
    }

    @Override
    public ConsistentHash getConsistentHashAtStart() {
        return this.consistentHashAtStart;
    }

    @Override
    public ConsistentHash getConsistentHashAtEnd() {
        return this.consistentHashAtEnd;
    }

    @Override
    public Map<K, V> getEntries() {
        return this.entries;
    }
}

