/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Map;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.ReplicationInterceptor;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.WriteSkewHelper;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionedReplicationInterceptor
extends ReplicationInterceptor {
    private static final Log log = LogFactory.getLog(VersionedReplicationInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected PrepareCommand buildPrepareCommandForResend(TxInvocationContext ctx, CommitCommand commit) {
        VersionedPrepareCommand command = this.cf.buildVersionedPrepareCommand(commit.getGlobalTransaction(), ctx.getModifications(), true);
        WriteSkewHelper.setVersionsSeenOnPrepareCommand(command, ctx);
        return command;
    }

    @Override
    protected void broadcastPrepare(TxInvocationContext context, PrepareCommand command) {
        if (!this.rpcManager.getTransport().isCoordinator()) {
            WriteSkewHelper.setVersionsSeenOnPrepareCommand((VersionedPrepareCommand)command, context);
            Map<Address, Response> resps = this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, true, true);
            Response r = resps.get(this.rpcManager.getTransport().getCoordinator());
            WriteSkewHelper.readVersionsFromResponse(r, context.getCacheTransaction());
        } else {
            super.broadcastPrepare(context, command);
        }
    }
}

