/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cacheviews;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Immutables;
import org.infinispan.util.Util;

@Immutable
public class CacheView {
    public static final CacheView EMPTY_CACHE_VIEW = new CacheView(-1, Collections.<Address>emptyList());
    private final int viewId;
    private final List<Address> members;

    public CacheView(int viewId, List<Address> members) {
        if (members == null) {
            throw new IllegalArgumentException("Member list cannot be null");
        }
        this.viewId = viewId;
        this.members = Immutables.immutableListCopy(members);
    }

    public int getViewId() {
        return this.viewId;
    }

    public List<Address> getMembers() {
        return this.members;
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public boolean contains(Address node) {
        return this.members.contains(node);
    }

    public boolean containsAny(Collection<Address> nodes) {
        for (Address node : nodes) {
            if (!this.members.contains(node)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheView cacheView = (CacheView)o;
        if (this.viewId != cacheView.viewId) {
            return false;
        }
        return !(this.members != null ? !((Object)this.members).equals(cacheView.members) : cacheView.members != null);
    }

    public int hashCode() {
        int result = this.viewId;
        result = 31 * result + (this.members != null ? ((Object)this.members).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CacheView{viewId=" + this.viewId + ", members=" + this.members + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<CacheView> {
        @Override
        public void writeObject(ObjectOutput output, CacheView cacheView) throws IOException {
            output.writeInt(cacheView.viewId);
            output.writeObject(cacheView.members);
        }

        @Override
        public CacheView readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            int viewId = unmarshaller.readInt();
            List members = (List)unmarshaller.readObject();
            return new CacheView(viewId, members);
        }

        @Override
        public Integer getId() {
            return 75;
        }

        @Override
        public Set<Class<? extends CacheView>> getTypeClasses() {
            return Util.asSet(CacheView.class);
        }
    }
}

