/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.List;
import org.infinispan.commands.statetransfer.StateResponseCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.concurrent.StateSequencer;
import org.infinispan.test.concurrent.StateSequencerUtil;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.NumOwnersNodeCrashInSequenceTest")
public class NumOwnersNodeCrashInSequenceTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(NumOwnersNodeCrashInSequenceTest.class);
    ControlledConsistentHashFactory cchf;
    private ConfigurationBuilder configBuilder;
    protected AvailabilityMode expectedAvailabilityMode;

    public NumOwnersNodeCrashInSequenceTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
        this.expectedAvailabilityMode = AvailabilityMode.DEGRADED_MODE;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.cchf = new ControlledConsistentHashFactory.Default(new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}});
        this.configBuilder = NumOwnersNodeCrashInSequenceTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        this.configBuilder.clustering().partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES);
        this.configBuilder.clustering().hash().numSegments(4).stateTransfer().timeout(30000L);
    }

    public void testNodeCrashedBeforeStFinished0() throws Exception {
        this.testNodeCrashedBeforeStFinished(0, 1, 2, 3);
    }

    public void testNodeCrashedBeforeStFinished1() throws Exception {
        this.testNodeCrashedBeforeStFinished(0, 2, 1, 3);
    }

    public void testNodeCrashedBeforeStFinished2() throws Exception {
        this.testNodeCrashedBeforeStFinished(0, 3, 1, 2);
    }

    public void testNodeCrashedBeforeStFinished3() throws Exception {
        this.testNodeCrashedBeforeStFinished(1, 2, 0, 3);
    }

    public void testNodeCrashedBeforeStFinished4() throws Exception {
        this.testNodeCrashedBeforeStFinished(1, 3, 0, 2);
    }

    public void testNodeCrashedBeforeStFinished5() throws Exception {
        this.testNodeCrashedBeforeStFinished(2, 3, 0, 1);
    }

    public void testNodeCrashedBeforeStFinished6() throws Exception {
        this.testNodeCrashedBeforeStFinished(1, 2, 3, 0);
    }

    public void testNodeCrashedBeforeStFinished7() throws Exception {
        this.testNodeCrashedBeforeStFinished(2, 3, 1, 0);
    }

    private void testNodeCrashedBeforeStFinished(int a0, int a1, int c0, int c1) throws Exception {
        Object[] allKeys;
        this.cchf.setOwnerIndexes(new int[][]{{a0, a1}, {a1, c0}, {c0, c1}, {c1, a0}});
        this.configBuilder.clustering().hash().consistentHashFactory((ConsistentHashFactory)this.cchf);
        this.createCluster(TestDataSCI.INSTANCE, this.configBuilder, 4);
        this.waitForClusterToForm();
        MagicKey k0 = new MagicKey("k1", this.cache(a0), this.cache(a1));
        MagicKey k1 = new MagicKey("k2", this.cache(a0), this.cache(a1));
        MagicKey k2 = new MagicKey("k3", this.cache(a1), this.cache(c0));
        MagicKey k3 = new MagicKey("k4", this.cache(a1), this.cache(c0));
        MagicKey k4 = new MagicKey("k5", this.cache(c0), this.cache(c1));
        MagicKey k5 = new MagicKey("k6", this.cache(c0), this.cache(c1));
        MagicKey k6 = new MagicKey("k7", this.cache(c1), this.cache(a0));
        MagicKey k7 = new MagicKey("k8", this.cache(c1), this.cache(a0));
        for (Object k : allKeys = new Object[]{k0, k1, k2, k3, k4, k5, k6, k7}) {
            this.cache(a0).put(k, k);
        }
        StateSequencer ss = new StateSequencer();
        ss.logicalThread("main", "main:st_in_progress", "main:2nd_node_left", "main:cluster_degraded", "main:after_cluster_degraded");
        StateSequencerUtil.advanceOnInboundRpc(ss, this.advancedCache(a1), StateSequencerUtil.matchCommand(StateResponseCommand.class).matchCount(0).build()).before("main:st_in_progress", "main:cluster_degraded");
        StateSequencerUtil.advanceOnInboundRpc(ss, this.advancedCache(a1), StateSequencerUtil.matchCommand(StateResponseCommand.class).matchCount(1).build()).before("main:after_cluster_degraded", new String[0]);
        this.cchf.setMembersToUse(this.advancedCache(a0).getRpcManager().getTransport().getMembers());
        this.cchf.setOwnerIndexes(new int[][]{{a0, a1}, {a1, c0}, {c0, a1}, {c0, a0}});
        Address address1 = this.address(c1);
        log.tracef("Before killing node %s", (Object)address1);
        this.crashCacheManagers(this.manager(c1));
        this.installNewView(this.advancedCache(a0).getRpcManager().getTransport().getMembers(), address1, this.manager(a0), this.manager(a1), this.manager(c0));
        ss.enter("main:2nd_node_left");
        Address address0 = this.address(c0);
        log.tracef("Killing 2nd node %s", (Object)address0);
        this.crashCacheManagers(this.manager(c0));
        this.installNewView(this.advancedCache(a0).getRpcManager().getTransport().getMembers(), address0, this.manager(a0), this.manager(a1));
        final PartitionHandlingManager phm0 = TestingUtil.extractComponent(this.cache(a0), PartitionHandlingManager.class);
        final PartitionHandlingManager phm1 = TestingUtil.extractComponent(this.cache(a1), PartitionHandlingManager.class);
        NumOwnersNodeCrashInSequenceTest.eventually(new AbstractInfinispanTest.Condition(){
            final /* synthetic */ NumOwnersNodeCrashInSequenceTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean isSatisfied() throws Exception {
                return phm0.getAvailabilityMode() == this.this$0.expectedAvailabilityMode && phm1.getAvailabilityMode() == this.this$0.expectedAvailabilityMode;
            }
        });
        ss.exit("main:2nd_node_left");
        log.trace((Object)"Testing condition");
        LocalizedCacheTopology topology = this.cache(a0).getAdvancedCache().getDistributionManager().getCacheTopology();
        AssertJUnit.assertEquals((int)3, (int)topology.getMembers().size());
        for (Object k : allKeys) {
            List owners = topology.getDistribution(k).readOwners();
            try {
                this.cache(a0).get(k);
                if (owners.contains(address0) || owners.contains(address1)) {
                    AssertJUnit.fail((String)("get(" + String.valueOf(k) + ") should have failed on cache " + String.valueOf(this.address(a0))));
                }
            }
            catch (AvailabilityException availabilityException) {
                // empty catch block
            }
            try {
                this.cache(a1).put(k, k);
                if (!owners.contains(address0) && !owners.contains(address1)) continue;
                AssertJUnit.fail((String)("put(" + String.valueOf(k) + ", v) should have failed on cache " + String.valueOf(this.address(a0))));
            }
            catch (AvailabilityException availabilityException) {
                // empty catch block
            }
        }
        log.debug((Object)"Changing partition availability mode back to AVAILABLE");
        this.cchf.setOwnerIndexes(new int[][]{{a0, a1}, {a1, a0}, {a0, a1}, {a1, a0}});
        LocalTopologyManager ltm = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(a0), LocalTopologyManager.class);
        ltm.setCacheAvailability(TestingUtil.getDefaultCacheName(this.manager(a0)), AvailabilityMode.AVAILABLE);
        TestingUtil.waitForNoRebalance(this.cache(a0), this.cache(a1));
        this.eventuallyEquals(AvailabilityMode.AVAILABLE, () -> ((PartitionHandlingManager)phm0).getAvailabilityMode());
    }

    private void installNewView(List<Address> members, Address missing, EmbeddedCacheManager ... where) {
        TestingUtil.installNewView(members.stream().filter(a -> !a.equals((Object)missing)), where);
    }

    protected void crashCacheManagers(EmbeddedCacheManager ... cacheManagers) {
        TestingUtil.crashCacheManagers(cacheManagers);
    }
}

