/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.expiration.impl.ExpirationFunctionalTest;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiration.impl.ExpirationStoreFunctionalTest")
public class ExpirationStoreFunctionalTest
extends ExpirationFunctionalTest {
    private boolean passivationEnabled;
    private final int MAX_IN_MEMORY = 5;

    ExpirationStoreFunctionalTest passivation(boolean enable) {
        this.passivationEnabled = enable;
        return this;
    }

    @Override
    @Factory
    public Object[] factory() {
        return new Object[]{new ExpirationStoreFunctionalTest().passivation(true).cacheMode(CacheMode.LOCAL), new ExpirationStoreFunctionalTest().passivation(false).cacheMode(CacheMode.LOCAL)};
    }

    @Override
    protected String parameters() {
        return "[passivation= " + this.passivationEnabled + "]";
    }

    @Override
    protected void configure(ConfigurationBuilder config) {
        config.memory().maxCount(this.passivationEnabled ? 5L : -1L).expiration().wakeUpInterval(Long.MAX_VALUE).persistence().passivation(this.passivationEnabled).addStore(DummyInMemoryStoreConfigurationBuilder.class);
    }

    @Override
    protected int maxInMemory() {
        return this.passivationEnabled ? 5 : super.maxInMemory();
    }

    public void testMaxIdleWithPassivation() {
        this.cache.put((Object)"will-expire", (Object)"uh oh", -1L, null, 1L, TimeUnit.MILLISECONDS);
        for (int i = 0; i < 10; ++i) {
            this.cache.put((Object)("key-" + i), (Object)("value-" + i), -1L, null, 10L, TimeUnit.MILLISECONDS);
        }
        AssertJUnit.assertEquals((int)11, (int)this.cache.size());
        this.timeService.advance(6L);
        AssertJUnit.assertEquals((int)10, (int)this.cache.getAdvancedCache().withFlags(Flag.SKIP_SIZE_OPTIMIZATION).size());
        AssertJUnit.assertNotNull((Object)this.cache.get((Object)"key-1"));
        AssertJUnit.assertNotNull((Object)this.cache.get((Object)"key-6"));
        AssertJUnit.assertNotNull((Object)this.cache.get((Object)"key-3"));
        this.processExpiration();
        this.timeService.advance(6L);
        AssertJUnit.assertEquals((int)3, (int)this.cache.getAdvancedCache().withFlags(Flag.SKIP_SIZE_OPTIMIZATION).size());
        this.timeService.advance(6L);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getAdvancedCache().withFlags(Flag.SKIP_SIZE_OPTIMIZATION).size());
        this.processExpiration();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getAdvancedCache().getDataContainer().sizeIncludingExpired());
    }
}

