/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.statetransfer.StateResponseCommand;
import org.infinispan.commands.statetransfer.StateTransferCancelCommand;
import org.infinispan.commands.statetransfer.StateTransferStartCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.ControlledRpcManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="commands.GetAllCommandNodeCrashTest")
public class GetAllCommandNodeCrashTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(3, TestDataSCI.INSTANCE, GetAllCommandNodeCrashTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        MagicKey key = new MagicKey(this.cache(0), this.cache(1));
        this.cache(2).put((Object)key, (Object)"value");
        CheckPoint checkPoint = new CheckPoint();
        ControlledRpcManager rpcManager = ControlledRpcManager.replaceRpcManager(this.cache(2), new Class[0]);
        rpcManager.excludeCommands(StateResponseCommand.class, StateTransferStartCommand.class, StateTransferCancelCommand.class);
        StateConsumer stateConsumerSpy = (StateConsumer)Mockito.spy((Object)TestingUtil.extractComponent(this.cache(2), StateConsumer.class));
        ((StateConsumer)Mockito.doAnswer(invocation -> {
            checkPoint.trigger("topology_update_blocked");
            checkPoint.awaitStrict("topology_update_resumed", 10L, TimeUnit.SECONDS);
            return invocation.callRealMethod();
        }).when((Object)stateConsumerSpy)).onTopologyUpdate((CacheTopology)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        TestingUtil.replaceComponent(this.cache(2), StateConsumer.class, stateConsumerSpy, true);
        Future<Map> f = this.fork(() -> this.cache(2).getAdvancedCache().getAll(Collections.singleton(key)));
        ControlledRpcManager.BlockedRequest<ClusteredGetAllCommand> blockedGetAll = rpcManager.expectCommand(ClusteredGetAllCommand.class);
        ((EmbeddedCacheManager)this.cacheManagers.get(0)).stop();
        checkPoint.awaitStrict("topology_update_blocked", 10L, TimeUnit.SECONDS);
        blockedGetAll.send().receiveAll();
        rpcManager.expectNoCommand();
        checkPoint.trigger("topology_update_resumed");
        rpcManager.expectCommand(ClusteredGetAllCommand.class).send().receiveAll();
        try {
            Map map = f.get(10L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull((Object)map);
            AssertJUnit.assertFalse((boolean)map.isEmpty());
            AssertJUnit.assertEquals((Object)"value", map.get(key));
        }
        finally {
            checkPoint.triggerForever("topology_update_resumed");
            rpcManager.stopBlocking();
        }
    }
}

