/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.infinispan.Cache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.irac.ControlledIracManager;
import org.infinispan.xsite.irac.DefaultIracManager;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.irac.IracManagerKeyInfo;
import org.infinispan.xsite.irac.IracManagerKeyState;
import org.infinispan.xsite.irac.IracXSiteBackup;
import org.infinispan.xsite.statetransfer.XSiteState;

public class ManualIracManager
extends ControlledIracManager {
    private final Map<Object, PendingKeyRequest> pendingKeys = new ConcurrentHashMap<Object, PendingKeyRequest>(16);
    private volatile boolean enabled;
    private final List<StateTransferRequest> pendingStateTransfer = new ArrayList<StateTransferRequest>(2);

    private ManualIracManager(IracManager actual) {
        super(actual);
    }

    public static ManualIracManager wrapCache(Cache<?, ?> cache) {
        IracManager iracManager = TestingUtil.extractComponent(cache, IracManager.class);
        if (iracManager instanceof ManualIracManager) {
            return (ManualIracManager)iracManager;
        }
        return TestingUtil.wrapComponent(cache, IracManager.class, ManualIracManager::new);
    }

    @Override
    public void trackUpdatedKey(int segment, Object key, Object lockOwner) {
        if (this.enabled) {
            this.pendingKeys.put(key, new PendingKeyRequest(key, lockOwner, segment, false));
        } else {
            super.trackUpdatedKey(segment, key, lockOwner);
        }
    }

    @Override
    public void trackExpiredKey(int segment, Object key, Object lockOwner) {
        if (this.enabled) {
            this.pendingKeys.put(key, new PendingKeyRequest(key, lockOwner, segment, true));
        } else {
            super.trackExpiredKey(segment, key, lockOwner);
        }
    }

    @Override
    public CompletionStage<Void> trackForStateTransfer(Collection<XSiteState> stateList) {
        if (this.enabled) {
            StateTransferRequest request = new StateTransferRequest(stateList);
            this.pendingStateTransfer.add(request);
            return request;
        }
        return super.trackForStateTransfer(stateList);
    }

    @Override
    public void requestState(Address requestor, IntSet segments) {
        this.asDefaultIracManager().ifPresent(im -> im.transferStateTo(requestor, segments, this.pendingKeys.values()));
        super.requestState(requestor, segments);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean containsKey(Object key) {
        if (this.pendingKeys.containsKey(key)) return true;
        if (super.containsKey(key)) return true;
        if (!this.pendingStateTransfer.stream().map(StateTransferRequest::getState).flatMap(Collection::stream).map(XSiteState::key).anyMatch(key::equals)) return false;
        return true;
    }

    public void sendKeys() {
        this.pendingKeys.values().forEach(this::send);
        this.pendingKeys.clear();
        this.pendingStateTransfer.forEach(this::send);
        this.pendingStateTransfer.clear();
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable(DisableMode disableMode) {
        this.enabled = false;
        switch (disableMode.ordinal()) {
            case 1: {
                this.pendingKeys.clear();
                this.pendingStateTransfer.clear();
                break;
            }
            case 0: {
                this.sendKeys();
            }
        }
    }

    public boolean isEmpty() {
        return this.asDefaultIracManager().map(DefaultIracManager::isEmpty).orElse(true);
    }

    boolean hasPendingKeys() {
        return !this.pendingKeys.isEmpty();
    }

    private void send(PendingKeyRequest request) {
        if (request.isExpiration()) {
            super.trackExpiredKey(request.getSegment(), request.getKey(), request.getOwner());
            return;
        }
        super.trackUpdatedKey(request.getSegment(), request.getKey(), request.getOwner());
    }

    private void send(StateTransferRequest request) {
        CompletionStage<Void> rsp = super.trackForStateTransfer(request.getState());
        rsp.whenComplete(request);
    }

    private static class PendingKeyRequest
    implements IracManagerKeyState {
        private final IracManagerKeyInfo keyInfo;
        private final boolean expiration;

        private PendingKeyRequest(Object key, Object lockOwner, int segment, boolean expiration) {
            this.keyInfo = new IracManagerKeyInfo(segment, key, lockOwner);
            this.expiration = expiration;
        }

        public IracManagerKeyInfo getKeyInfo() {
            return this.keyInfo;
        }

        public Object getKey() {
            return this.keyInfo.key;
        }

        public Object getOwner() {
            return this.keyInfo.owner;
        }

        public int getSegment() {
            return this.keyInfo.segment;
        }

        public boolean isExpiration() {
            return this.expiration;
        }

        public boolean isStateTransfer() {
            return false;
        }

        public boolean canSend() {
            return false;
        }

        public void retry() {
        }

        public boolean isDone() {
            return false;
        }

        public void discard() {
        }

        public void successFor(IracXSiteBackup site) {
        }

        public boolean wasSuccessful(IracXSiteBackup site) {
            return false;
        }
    }

    private static class StateTransferRequest
    extends CompletableFuture<Void>
    implements BiConsumer<Void, Throwable> {
        private final Collection<XSiteState> state;

        private StateTransferRequest(Collection<XSiteState> state) {
            this.state = new ArrayList<XSiteState>(state);
        }

        Collection<XSiteState> getState() {
            return this.state;
        }

        @Override
        public void accept(Void unused, Throwable throwable) {
            if (throwable != null) {
                this.completeExceptionally(throwable);
            } else {
                this.complete(null);
            }
        }
    }

    public static enum DisableMode {
        SEND,
        DROP;

    }
}

