/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.commands.module.TestGlobalConfigurationBuilder;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.dummy.Element;
import org.infinispan.persistence.spi.ExternalStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.MultiCacheManagerCallable;
import org.infinispan.test.TestException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="manager.CacheManagerTest")
public class CacheManagerTest
extends AbstractInfinispanTest {
    private static final String CACHE_NAME = "name";

    public void testDefaultCache() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(false);
        try {
            AssertJUnit.assertEquals((Object)ComponentStatus.RUNNING, (Object)cm.getCache().getStatus());
            AssertJUnit.assertEquals((String)TestingUtil.getDefaultCacheName(cm), (String)cm.getCache().getName());
            Exceptions.expectException(CacheConfigurationException.class, () -> cm.defineConfiguration(TestingUtil.getDefaultCacheName(cm), new ConfigurationBuilder().build()));
            Exceptions.expectException(CacheConfigurationException.class, () -> cm.getCache("non-existent-cache"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    public void testDefaultCacheStartedAutomatically() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(new ConfigurationBuilder());
        try {
            AssertJUnit.assertEquals(new HashSet<String>(Arrays.asList(TestingUtil.getDefaultCacheName(cm))), (Object)cm.getCacheNames());
            ComponentRegistry cr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)cm).getNamedComponentRegistry(TestingUtil.getDefaultCacheName(cm));
            AssertJUnit.assertEquals((Object)ComponentStatus.RUNNING, (Object)cr.getStatus());
            AssertJUnit.assertEquals((String)TestingUtil.getDefaultCacheName(cm), (String)cr.getCacheName());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    public void testUnstartedCachemanager() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(false)){

            @Override
            public void call() {
                AssertJUnit.assertEquals((Object)ComponentStatus.INSTANTIATED, (Object)this.cm.getStatus());
                AssertJUnit.assertFalse((boolean)this.cm.getStatus().allowInvocations());
                Cache cache = this.cm.getCache();
                cache.put((Object)"k", (Object)"v");
                AssertJUnit.assertEquals((Object)cache.get((Object)"k"), (Object)"v");
            }
        });
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testClashingNames() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(false);
        try {
            ConfigurationBuilder c = new ConfigurationBuilder();
            cm.defineConfiguration("aCache", c.build());
            cm.defineConfiguration("aCache", c.build());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWildcardTemplateNameMatchingInternalCache() {
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
        holder.newConfigurationBuilder("*").template(true).clustering().cacheMode(CacheMode.LOCAL).memory().maxCount(1L);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(holder);
        try {
            Cache aCache = cm.getCache("a");
            AssertJUnit.assertEquals((long)1L, (long)aCache.getCacheConfiguration().memory().maxCount());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartAndStop() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(false);
        try {
            cm.defineConfiguration("cache1", new ConfigurationBuilder().build());
            cm.defineConfiguration("cache2", new ConfigurationBuilder().build());
            cm.defineConfiguration("cache3", new ConfigurationBuilder().build());
            Cache c1 = cm.getCache("cache1");
            Cache c2 = cm.getCache("cache2");
            Cache c3 = cm.getCache("cache3");
            AssertJUnit.assertEquals((Object)ComponentStatus.RUNNING, (Object)c1.getStatus());
            AssertJUnit.assertEquals((Object)ComponentStatus.RUNNING, (Object)c2.getStatus());
            AssertJUnit.assertEquals((Object)ComponentStatus.RUNNING, (Object)c3.getStatus());
            cm.stop();
            AssertJUnit.assertEquals((Object)ComponentStatus.TERMINATED, (Object)c1.getStatus());
            AssertJUnit.assertEquals((Object)ComponentStatus.TERMINATED, (Object)c2.getStatus());
            AssertJUnit.assertEquals((Object)ComponentStatus.TERMINATED, (Object)c3.getStatus());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    public void testDefiningConfigurationValidation() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(false);
        Exceptions.expectException(NullPointerException.class, () -> cm.defineConfiguration("cache1", null));
        Exceptions.expectException(NullPointerException.class, () -> cm.defineConfiguration(null, null));
        Exceptions.expectException(NullPointerException.class, () -> cm.defineConfiguration(null, new ConfigurationBuilder().build()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefineConfigurationTwice() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(false);
        try {
            Configuration override = new ConfigurationBuilder().invocationBatching().enable().build();
            AssertJUnit.assertTrue((boolean)override.invocationBatching().enabled());
            AssertJUnit.assertTrue((boolean)cm.defineConfiguration("test1", override).invocationBatching().enabled());
            ConfigurationBuilder cb = new ConfigurationBuilder();
            cb.read(override, Combine.DEFAULT);
            Configuration config = cb.build();
            AssertJUnit.assertTrue((boolean)config.invocationBatching().enabled());
            AssertJUnit.assertTrue((boolean)cm.defineConfiguration("test2", config).invocationBatching().enabled());
        }
        finally {
            cm.stop();
        }
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN000436:.*")
    public void testMissingDefaultConfiguration() {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        gcb.jmx().enabled(false);
        DefaultCacheManager cm = new DefaultCacheManager(gcb.build());
        try {
            cm.getCache("someCache");
        }
        finally {
            cm.stop();
        }
    }

    public void testGetCacheNames() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(false);
        try {
            cm.defineConfiguration("one", new ConfigurationBuilder().build());
            cm.defineConfiguration("two", new ConfigurationBuilder().build());
            cm.defineConfiguration("three", new ConfigurationBuilder().build());
            cm.getCache("three");
            Set cacheNames = cm.getCacheNames();
            AssertJUnit.assertEquals((int)4, (int)cacheNames.size());
            AssertJUnit.assertTrue((boolean)cacheNames.contains("one"));
            AssertJUnit.assertTrue((boolean)cacheNames.contains("two"));
            AssertJUnit.assertTrue((boolean)cacheNames.contains("three"));
        }
        finally {
            cm.stop();
        }
    }

    public void testCacheStopTwice() {
        EmbeddedCacheManager localCacheManager = TestCacheManagerFactory.createCacheManager(false);
        try {
            Cache cache = localCacheManager.getCache();
            cache.put((Object)"k", (Object)"v");
            cache.stop();
            cache.stop();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(localCacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(localCacheManager);
    }

    public void testCacheManagerStopTwice() {
        EmbeddedCacheManager localCacheManager = TestCacheManagerFactory.createCacheManager(false);
        try {
            Cache cache = localCacheManager.getCache();
            cache.put((Object)"k", (Object)"v");
            localCacheManager.stop();
            localCacheManager.stop();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(localCacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(localCacheManager);
    }

    @Test(expectedExceptions={IllegalLifecycleStateException.class})
    public void testCacheStopManagerStopFollowedByGetCache() {
        EmbeddedCacheManager localCacheManager = TestCacheManagerFactory.createCacheManager(false);
        try {
            Cache cache = localCacheManager.getCache();
            cache.put((Object)"k", (Object)"v");
            cache.stop();
            localCacheManager.stop();
            localCacheManager.getCache();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(localCacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(localCacheManager);
    }

    @Test(expectedExceptions={IllegalLifecycleStateException.class})
    public void testCacheStopManagerStopFollowedByCacheOp() {
        EmbeddedCacheManager localCacheManager = TestCacheManagerFactory.createCacheManager(false);
        try {
            Cache cache = localCacheManager.getCache();
            cache.put((Object)"k", (Object)"v");
            cache.stop();
            localCacheManager.stop();
            cache.put((Object)"k", (Object)"v2");
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(localCacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(localCacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentCacheManagerStopAndGetCache() throws Exception {
        EmbeddedCacheManager manager = TestCacheManagerFactory.createCacheManager(false);
        CompletableFuture<Void> cacheStartBlocked = new CompletableFuture<Void>();
        CompletableFuture<Void> cacheStartResumed = new CompletableFuture<Void>();
        CompletableFuture<Void> managerStopBlocked = new CompletableFuture<Void>();
        CompletableFuture<Void> managerStopResumed = new CompletableFuture<Void>();
        try {
            manager.addListener((Object)new MyListener(CACHE_NAME, cacheStartBlocked, cacheStartResumed));
            TestingUtil.replaceComponent((CacheContainer)manager, GlobalMarshaller.class, new LatchGlobalMarshaller(managerStopBlocked, managerStopResumed), true);
            manager.start();
            Future<Cache> cacheStartFuture = this.fork(() -> manager.createCache(CACHE_NAME, new ConfigurationBuilder().build()));
            cacheStartBlocked.get(10L, TimeUnit.SECONDS);
            Future<Void> managerStopFuture = this.fork(() -> manager.stop());
            Exceptions.expectException(TimeoutException.class, () -> managerStopBlocked.get(1L, TimeUnit.SECONDS));
            Future<Cache> cacheStartFuture2 = this.fork(() -> manager.getCache(CACHE_NAME));
            Exceptions.expectExecutionException(IllegalLifecycleStateException.class, cacheStartFuture2);
            cacheStartResumed.complete(null);
            cacheStartFuture.get(10L, TimeUnit.SECONDS);
            managerStopBlocked.get(10L, TimeUnit.SECONDS);
            managerStopResumed.complete(null);
            managerStopFuture.get(10L, TimeUnit.SECONDS);
            cacheStartBlocked.complete(null);
        }
        catch (Throwable throwable) {
            cacheStartBlocked.complete(null);
            cacheStartResumed.complete(null);
            managerStopBlocked.complete(null);
            managerStopResumed.complete(null);
            TestingUtil.killCacheManagers(manager);
            throw throwable;
        }
        cacheStartResumed.complete(null);
        managerStopBlocked.complete(null);
        managerStopResumed.complete(null);
        TestingUtil.killCacheManagers(manager);
    }

    public void testConcurrentStopDuringStart() throws Exception {
        CheckPoint checkPoint = new CheckPoint();
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder();
        ((TestGlobalConfigurationBuilder)globalBuilder.addModule(TestGlobalConfigurationBuilder.class)).cacheManagerStartedCallback(() -> {
            checkPoint.trigger("cache_manager_starting");
            try {
                checkPoint.awaitStrict("cache_manager_proceed", 15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | TimeoutException e) {
                org.junit.jupiter.api.Assertions.fail((Throwable)e);
            }
        });
        EmbeddedCacheManager manager = TestCacheManagerFactory.createCacheManager(globalBuilder, new ConfigurationBuilder(), false);
        Future<Void> starting = this.fork(() -> ((EmbeddedCacheManager)manager).start());
        checkPoint.awaitStrict("cache_manager_starting", 10L, TimeUnit.SECONDS);
        Assertions.assertThat((manager.getStatus() == ComponentStatus.INITIALIZING ? 1 : 0) != 0).isTrue();
        manager.stop();
        CacheManagerTest.eventually(() -> manager.getStatus() == ComponentStatus.TERMINATED);
        checkPoint.trigger("cache_manager_proceed");
        starting.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((manager.getStatus() == ComponentStatus.TERMINATED ? 1 : 0) != 0).isTrue();
    }

    public void testRemoveNonExistentCache(Method m) {
        EmbeddedCacheManager manager = this.getManagerWithStore(m, false, false);
        try {
            manager.getCache("cache");
            manager.administration().removeCache("does-not-exist");
        }
        finally {
            manager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveCacheLocal(Method m) {
        EmbeddedCacheManager manager = this.getManagerWithStore(m, false, false);
        try {
            Cache cache = manager.getCache("cache");
            cache.put((Object)TestingUtil.k(m, 1), (Object)TestingUtil.v(m, 1));
            cache.put((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m, 2));
            cache.put((Object)TestingUtil.k(m, 3), (Object)TestingUtil.v(m, 3));
            DummyInMemoryStore store = this.getDummyStore((Cache<String, String>)cache);
            DataContainer<?, ?> data = this.getDataContainer((Cache<String, String>)cache);
            AssertJUnit.assertFalse((boolean)store.isEmpty());
            AssertJUnit.assertTrue((0 != data.size() ? 1 : 0) != 0);
            manager.administration().removeCache("cache");
            AssertJUnit.assertEquals((long)0L, (long)DummyInMemoryStore.getStoreDataSize(store.getStoreName()));
            AssertJUnit.assertEquals((int)0, (int)data.size());
            manager.administration().removeCache("cache");
            AssertJUnit.assertEquals((long)0L, (long)DummyInMemoryStore.getStoreDataSize(store.getStoreName()));
            AssertJUnit.assertEquals((int)0, (int)data.size());
        }
        finally {
            manager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(expectedExceptions={CacheException.class})
    public void testStartCachesFailed() {
        EmbeddedCacheManager cacheManager = null;
        try {
            GlobalConfigurationBuilder global = new GlobalConfigurationBuilder().nonClusteredDefault();
            TestCacheManagerFactory.addInterceptor(global, "incorrect"::equals, (AsyncInterceptor)new ExceptionInterceptor(), TestCacheManagerFactory.InterceptorPosition.FIRST, null);
            cacheManager = TestCacheManagerFactory.createCacheManager(global, null);
            Configuration configuration = new ConfigurationBuilder().build();
            cacheManager.defineConfiguration("correct-cache-1", configuration);
            cacheManager.defineConfiguration("correct-cache-2", configuration);
            cacheManager.defineConfiguration("correct-cache-3", configuration);
            cacheManager.defineConfiguration("incorrect", configuration);
            cacheManager.startCaches(new String[]{"correct-cache-1", "correct-cache-2", "correct-cache-3", "incorrect"});
            if (cacheManager == null) return;
        }
        catch (Throwable throwable) {
            if (cacheManager == null) throw throwable;
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }

    public void testCacheManagerStartFailure() {
        FailingGlobalComponent failingGlobalComponent = new FailingGlobalComponent();
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder();
        ((TestGlobalConfigurationBuilder)globalBuilder.addModule(TestGlobalConfigurationBuilder.class)).testGlobalComponent(FailingGlobalComponent.class.getName(), (Object)failingGlobalComponent);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Exceptions.expectException(EmbeddedCacheManagerStartupException.class, () -> TestCacheManagerFactory.createCacheManager(globalBuilder, builder));
        AssertJUnit.assertTrue((boolean)failingGlobalComponent.started);
        AssertJUnit.assertTrue((boolean)failingGlobalComponent.stopped);
    }

    public void testCacheManagerRestartReusingConfigurations() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() {
                EmbeddedCacheManager cm1 = this.cms[0];
                EmbeddedCacheManager cm2 = this.cms[1];
                TestingUtil.waitForNoRebalance(cm1.getCache(), cm2.getCache());
                Cache c1 = cm1.getCache();
                GlobalConfiguration globalCfg = cm1.getCacheManagerConfiguration();
                Configuration cfg = c1.getCacheConfiguration();
                TestingUtil.killCacheManagers(cm1);
                ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
                holder.getGlobalConfigurationBuilder().read(globalCfg);
                holder.getNamedConfigurationBuilders().put("defaultcache", new ConfigurationBuilder().read(cfg, Combine.DEFAULT));
                TestingUtil.withCacheManager(new CacheManagerCallable((EmbeddedCacheManager)new DefaultCacheManager(holder, true)){

                    @Override
                    public void call() {
                        Cache c = this.cm.getCache();
                        c.put((Object)1, (Object)"v1");
                        AssertJUnit.assertEquals((Object)"v1", (Object)c.get((Object)1));
                    }
                });
            }
        });
    }

    public void testRemoveCacheClusteredLocalStores(Method m) throws Exception {
        this.doTestRemoveCacheClustered(m, false);
    }

    public void testRemoveCacheClusteredSharedStores(Method m) throws Exception {
        this.doTestRemoveCacheClustered(m, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExceptionOnCacheManagerStop() {
        ConfigurationBuilder c = new ConfigurationBuilder();
        ((UnreliableCacheStoreConfigurationBuilder)c.persistence().addStore(UnreliableCacheStoreConfigurationBuilder.class)).segmented(false);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(c);
        try {
            AssertJUnit.assertEquals((Object)ComponentStatus.RUNNING, (Object)cm.getStatus());
            Cache cache = cm.getCache();
            cache.put((Object)1, (Object)"v1");
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            AssertJUnit.assertEquals((Object)ComponentStatus.TERMINATED, (Object)cm.getStatus());
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
        AssertJUnit.assertEquals((Object)ComponentStatus.TERMINATED, (Object)cm.getStatus());
    }

    public void testDefineConfigurationWithOverrideAndTemplate() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createClusteredCacheManager()){

            @Override
            public void call() {
                CacheMode cacheMode = CacheMode.DIST_ASYNC;
                String templateName = "dist-cache-template";
                this.cm.defineConfiguration(templateName, new ConfigurationBuilder().clustering().cacheMode(cacheMode).template(true).build());
                CacheMode overrideCacheMode = CacheMode.REPL_ASYNC;
                Configuration overrideConfiguration = new ConfigurationBuilder().clustering().cacheMode(overrideCacheMode).build();
                String ourCacheName = "my-cache";
                this.cm.defineConfiguration(ourCacheName, templateName, overrideConfiguration);
                Cache cache = this.cm.getCache(ourCacheName);
                AssertJUnit.assertEquals((Object)overrideCacheMode, (Object)cache.getCacheConfiguration().clustering().cacheMode());
            }
        });
    }

    public void testCacheNameLength() {
        final String cacheName = new String(new char[256]);
        final String exceptionMessage = String.format("ISPN000663: Name must be less than 256 bytes, current name '%s' exceeds the size.", cacheName);
        final Configuration configuration = new ConfigurationBuilder().build();
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            @Override
            public void call() {
                Exceptions.expectException((String)exceptionMessage, () -> this.cm.createCache(cacheName, configuration), (Class[])new Class[]{CacheConfigurationException.class});
                Exceptions.expectException((String)exceptionMessage, () -> this.cm.defineConfiguration(cacheName, configuration), (Class[])new Class[]{CacheConfigurationException.class});
            }
        });
    }

    private EmbeddedCacheManager getManagerWithStore(Method m, boolean isClustered, boolean isStoreShared) {
        return this.getManagerWithStore(m, isClustered, isStoreShared, "store-");
    }

    private EmbeddedCacheManager getManagerWithStore(Method m, boolean isClustered, boolean isStoreShared, String storePrefix) {
        String storeName = storePrefix + m.getName();
        ConfigurationBuilder c = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)c.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(storeName).shared(isStoreShared)).clustering().cacheMode(isClustered ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder().clusteredDefault();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(gcb, c);
        cm.defineConfiguration("cache", c.build());
        return cm;
    }

    private void doTestRemoveCacheClustered(final Method m, boolean isStoreShared) {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{this.getManagerWithStore(m, true, isStoreShared, "store1-"), this.getManagerWithStore(m, true, isStoreShared, "store2-")}){

            @Override
            public void call() {
                EmbeddedCacheManager manager1 = this.cms[0];
                EmbeddedCacheManager manager2 = this.cms[0];
                Cache cache1 = manager1.getCache("cache", true);
                Cache cache2 = manager2.getCache("cache", true);
                AssertJUnit.assertNotNull((Object)cache1);
                AssertJUnit.assertNotNull((Object)cache2);
                AssertJUnit.assertTrue((boolean)manager1.cacheExists("cache"));
                AssertJUnit.assertTrue((boolean)manager2.cacheExists("cache"));
                cache1.put((Object)TestingUtil.k(m, 1), (Object)TestingUtil.v(m, 1));
                cache1.put((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m, 2));
                cache1.put((Object)TestingUtil.k(m, 3), (Object)TestingUtil.v(m, 3));
                cache2.put((Object)TestingUtil.k(m, 4), (Object)TestingUtil.v(m, 4));
                cache2.put((Object)TestingUtil.k(m, 5), (Object)TestingUtil.v(m, 5));
                DummyInMemoryStore store1 = CacheManagerTest.this.getDummyStore((Cache<String, String>)cache1);
                DataContainer<?, ?> data1 = CacheManagerTest.this.getDataContainer((Cache<String, String>)cache1);
                DummyInMemoryStore store2 = CacheManagerTest.this.getDummyStore((Cache<String, String>)cache2);
                DataContainer<?, ?> data2 = CacheManagerTest.this.getDataContainer((Cache<String, String>)cache2);
                AssertJUnit.assertFalse((boolean)store1.isEmpty());
                AssertJUnit.assertEquals((int)5, (int)data1.size());
                AssertJUnit.assertFalse((boolean)store2.isEmpty());
                AssertJUnit.assertEquals((int)5, (int)data2.size());
                manager1.administration().removeCache("cache");
                AssertJUnit.assertFalse((boolean)manager1.cacheExists("cache"));
                AssertJUnit.assertFalse((boolean)manager2.cacheExists("cache"));
                AssertJUnit.assertNull((Object)manager1.getCache("cache", false));
                AssertJUnit.assertNull((Object)manager2.getCache("cache", false));
                AssertJUnit.assertEquals((long)0L, (long)DummyInMemoryStore.getStoreDataSize(store1.getStoreName()));
                AssertJUnit.assertEquals((int)0, (int)data1.size());
                AssertJUnit.assertEquals((long)0L, (long)DummyInMemoryStore.getStoreDataSize(store2.getStoreName()));
                AssertJUnit.assertEquals((int)0, (int)data2.size());
            }
        });
    }

    private DummyInMemoryStore getDummyStore(Cache<String, String> cache1) {
        return (DummyInMemoryStore)TestingUtil.getFirstStore(cache1);
    }

    private DataContainer<?, ?> getDataContainer(Cache<String, String> cache) {
        return (DataContainer)TestingUtil.extractComponent(cache, InternalDataContainer.class);
    }

    @Listener
    private static class MyListener {
        private final String cacheName;
        private final CompletableFuture<Void> cacheStartBlocked;
        private final CompletableFuture<Void> cacheStartResumed;

        public MyListener(String cacheName, CompletableFuture<Void> cacheStartBlocked, CompletableFuture<Void> cacheStartResumed) {
            this.cacheName = cacheName;
            this.cacheStartBlocked = cacheStartBlocked;
            this.cacheStartResumed = cacheStartResumed;
        }

        @CacheStarted
        public void cacheStarted(CacheStartedEvent event) {
            log.tracef("Cache started: %s", (Object)event.getCacheName());
            if (this.cacheName.equals(event.getCacheName())) {
                this.cacheStartBlocked.complete(null);
                this.cacheStartResumed.join();
            }
        }

        @CacheStopped
        public void cacheStopped(CacheStoppedEvent event) {
            log.tracef("Cache stopped: %s", (Object)event.getCacheName());
        }
    }

    static class LatchGlobalMarshaller
    extends GlobalMarshaller {
        private final CompletableFuture<Void> managerStopBlocked;
        private final CompletableFuture<Void> managerStopResumed;

        public LatchGlobalMarshaller(CompletableFuture<Void> managerStopBlocked, CompletableFuture<Void> managerStopResumed) {
            this.managerStopBlocked = managerStopBlocked;
            this.managerStopResumed = managerStopResumed;
        }

        public void stop() {
            log.tracef("Stopping global component registry", new Object[0]);
            this.managerStopBlocked.complete(null);
            this.managerStopResumed.join();
            super.stop();
        }
    }

    static class ExceptionInterceptor
    extends BaseCustomAsyncInterceptor {
        ExceptionInterceptor() {
        }

        protected void start() {
            throw new IllegalStateException();
        }
    }

    @Scope(value=Scopes.GLOBAL)
    public static class FailingGlobalComponent {
        private boolean started;
        private boolean stopped;

        @Start
        public void start() {
            this.started = true;
            throw new TestException();
        }

        @Stop
        public void stop() {
            this.stopped = true;
        }
    }

    public static class UnreliableCacheStoreConfigurationBuilder
    extends AbstractStoreConfigurationBuilder<UnreliableCacheStoreConfiguration, UnreliableCacheStoreConfigurationBuilder> {
        public UnreliableCacheStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
            super(builder, UnreliableCacheStoreConfiguration.attributeDefinitionSet());
        }

        public UnreliableCacheStoreConfiguration create() {
            return new UnreliableCacheStoreConfiguration(this.attributes.protect(), this.async.create());
        }

        public UnreliableCacheStoreConfigurationBuilder self() {
            return this;
        }
    }

    @ConfigurationFor(value=UnreliableCacheStore.class)
    @BuiltBy(value=UnreliableCacheStoreConfigurationBuilder.class)
    public static class UnreliableCacheStoreConfiguration
    extends AbstractStoreConfiguration<UnreliableCacheStoreConfiguration> {
        public UnreliableCacheStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async) {
            super((Enum)Element.DUMMY_STORE, attributes, async, new ConfigurationElement[0]);
        }
    }

    public static class UnreliableCacheStore
    implements ExternalStore<Object, Object> {
        public void init(InitializationContext ctx) {
        }

        public void write(MarshallableEntry<?, ?> entry) {
        }

        public boolean delete(Object key) {
            return false;
        }

        public MarshallableEntry<Object, Object> loadEntry(Object key) {
            return null;
        }

        public boolean contains(Object key) {
            return false;
        }

        public void start() {
        }

        public void stop() {
            throw new IllegalStateException("Test");
        }
    }
}

