/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import jakarta.transaction.Transaction;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.lock.singlelock.AbstractCrashTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractLockOwnerCrashTest
extends AbstractCrashTest {
    protected EmbeddedTransaction transaction;

    public AbstractLockOwnerCrashTest(CacheMode cacheMode, LockingMode lockingMode, Boolean useSynchronization) {
        super(cacheMode, lockingMode, useSynchronization);
    }

    public void testOwnerChangesAfterPrepare1() throws Exception {
        this.testOwnerChangesAfterPrepare(0);
    }

    public void testOwnerChangesAfterPrepare2() throws Exception {
        this.testOwnerChangesAfterPrepare(1);
    }

    private void testOwnerChangesAfterPrepare(int secondTxNode) throws Exception {
        Object k = this.getKeyForCache(2);
        this.fork(() -> {
            try {
                this.tm(1).begin();
                this.cache(1).put(k, (Object)"v");
                this.transaction = (EmbeddedTransaction)this.tm(1).getTransaction();
                log.trace((Object)"Before preparing");
                this.transaction.runPrepare();
                this.tm(1).suspend();
            }
            catch (Throwable e) {
                log.errorf(e, "Error preparing transaction for key %s", k);
            }
        });
        AbstractLockOwnerCrashTest.eventually(() -> this.checkTxCount(0, 0, 1) && this.checkTxCount(1, 1, 0) && this.checkTxCount(2, 0, 1));
        this.killMember(2);
        assert (this.caches().size() == 2);
        this.tm(secondTxNode).begin();
        Transaction suspend = this.tm(secondTxNode).suspend();
        this.fork(() -> {
            try {
                log.trace((Object)"This thread runs a different tx");
                this.tm(secondTxNode).resume(suspend);
                this.cache(secondTxNode).put(k, (Object)"v2");
                this.tm(secondTxNode).commit();
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Error committing transaction for key %s", k);
            }
        });
        Thread.sleep(1000L);
        log.trace((Object)"Before completing the transaction!");
        this.tm(1).resume((Transaction)this.transaction);
        this.transaction.runCommit(false);
        AbstractLockOwnerCrashTest.eventually(() -> this.cache(0).get(k).equals("v2") && this.cache(1).get(k).equals("v2"), 15000L);
        this.assertNotLocked(k);
        AbstractLockOwnerCrashTest.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 0, 0));
    }
}

