/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$generator$;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.immutables.value.internal.$generator$.$Compiler;
import org.immutables.value.internal.$guava$.base.$Function;
import org.immutables.value.internal.$guava$.base.$Functions;
import org.immutables.value.internal.$guava$.base.$Predicate;
import org.immutables.value.internal.$guava$.base.$Predicates;
import org.immutables.value.internal.$guava$.collect.$ArrayListMultimap;
import org.immutables.value.internal.$guava$.collect.$FluentIterable;
import org.immutables.value.internal.$guava$.collect.$HashMultimap;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableListMultimap;
import org.immutables.value.internal.$guava$.collect.$Iterables;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$guava$.collect.$Maps;
import org.immutables.value.internal.$guava$.collect.$Ordering;

public final class $SourceOrdering {
    private static final OrderingProvider DEFAULT_PROVIDER = new OrderingProvider(){

        @Override
        public $Ordering<Element> enclosedBy(Element element) {
            return $Ordering.explicit(element.getEnclosedElements());
        }
    };
    private static final OrderingProvider PROVIDER = $SourceOrdering.createProvider();
    private static final boolean USE_LEGACY_ACCESSOR_ORDERING = Boolean.getBoolean("org.immutables.useLegacyAccessorOrdering");

    private $SourceOrdering() {
    }

    public static $ImmutableList<Element> getEnclosedElements(Element element) {
        return $SourceOrdering.enclosedBy(element).immutableSortedCopy(element.getEnclosedElements());
    }

    public static $Ordering<Element> enclosedBy(Element element) {
        return PROVIDER.enclosedBy(element);
    }

    private static OrderingProvider createProvider() {
        if ($Compiler.ECJ.isPresent() && !Boolean.getBoolean("org.immutables.disableEclipseOrderingProvider")) {
            return new EclipseCompilerOrderingProvider();
        }
        return DEFAULT_PROVIDER;
    }

    public static AccessorProvider getAllAccessorsProvider(Elements elements, Types types, TypeElement originatingType) {
        return $SourceOrdering.getAllAccessorsProvider(elements, types, originatingType, false);
    }

    public static AccessorProvider getAllAccessorsProvider(Elements elements, Types types, final TypeElement originatingType, final boolean useLegacyAccessorOrdering) {
        class CollectedOrdering
        extends $Ordering<Element> {
            final boolean useLegacyMode;
            final Map<String, 1CollectedOrdering.Intratype> accessorOrderings;
            final $ArrayListMultimap<String, TypeElement> accessorMapping;
            final $Predicate<String> includeAccessorInOrdering;
            final Set<TypeElement> linearizedTypes;

            CollectedOrdering() {
                this.useLegacyMode = useLegacyAccessorOrdering || USE_LEGACY_ACCESSOR_ORDERING;
                this.accessorOrderings = new LinkedHashMap<String, 1CollectedOrdering.Intratype>();
                this.accessorMapping = $ArrayListMultimap.create();
                this.includeAccessorInOrdering = this.useLegacyMode ? $Predicates.not($Predicates.in(this.accessorOrderings.keySet())) : $Predicates.alwaysTrue();
                this.linearizedTypes = this.useLegacyMode ? new BottomUpOrdering().traverseElements(originatingType) : new TopDownOrdering().traverseElements(originatingType);
                this.collectAccessors();
            }

            void collectAccessors() {
                int i = 0;
                for (TypeElement type : this.linearizedTypes) {
                    $ImmutableList<String> accessorsInType = $FluentIterable.from($SourceOrdering.getEnclosedElements(type)).filter(IsParameterlessNonstaticNonobject.PREDICATE).transform(ToSimpleName.FUNCTION).toList();
                    String typeTag = type.getSimpleName().toString();
                    1CollectedOrdering.Intratype intratype = new 1CollectedOrdering.Intratype(typeTag, i++, accessorsInType);
                    for (String name : accessorsInType) {
                        this.accessorMapping.put((Object)name, (Object)type);
                        if (!this.includeAccessorInOrdering.apply(name)) continue;
                        this.accessorOrderings.put(name, intratype);
                    }
                }
            }

            @Override
            public int compare(Element left, Element right) {
                String leftKey = ToSimpleName.FUNCTION.apply(left);
                String rightKey = ToSimpleName.FUNCTION.apply(right);
                1CollectedOrdering.Intratype leftIntratype = this.accessorOrderings.get(leftKey);
                1CollectedOrdering.Intratype rightIntratype = this.accessorOrderings.get(rightKey);
                if (leftIntratype == null || rightIntratype == null) {
                    return 0;
                }
                return leftIntratype == rightIntratype ? leftIntratype.ordering.compare(leftKey, rightKey) : Integer.compare(leftIntratype.rank, rightIntratype.rank);
            }

            class 1CollectedOrdering.Intratype {
                final String inType;
                final $Ordering<String> ordering;
                final int rank;

                1CollectedOrdering.Intratype(String inType, int rank, List<String> accessors) {
                    this.inType = inType;
                    this.rank = rank;
                    this.ordering = $Ordering.explicit(accessors);
                }

                public String toString() {
                    return "(<=> " + this.inType + ", " + this.rank + ", " + this.ordering + ")";
                }
            }
        }
        final CollectedOrdering ordering = new CollectedOrdering();
        final $ImmutableList<ExecutableElement> sortedList = ordering.immutableSortedCopy($SourceOrdering.disambiguateMethods(ElementFilter.methodsIn(elements.getAllMembers(originatingType))));
        return new AccessorProvider(){
            final $ImmutableListMultimap<String, TypeElement> accessorMapping;
            {
                this.accessorMapping = $ImmutableListMultimap.copyOf(ordering.accessorMapping);
            }

            @Override
            public $ImmutableListMultimap<String, TypeElement> accessorMapping() {
                return this.accessorMapping;
            }

            @Override
            public $ImmutableList<ExecutableElement> get() {
                return sortedList;
            }
        };
    }

    private static List<ExecutableElement> disambiguateMethods(Iterable<? extends ExecutableElement> methods) {
        $HashMultimap<String, ExecutableElement> methodsAlternatives = $HashMultimap.create();
        for (ExecutableElement executableElement : methods) {
            if (!IsParameterlessNonstaticNonobject.PREDICATE.apply(executableElement)) continue;
            methodsAlternatives.put(ToSimpleName.FUNCTION.apply(executableElement), executableElement);
        }
        ArrayList<ExecutableElement> resolvedMethods = $Lists.newArrayList();
        block1: for (Map.Entry e : methodsAlternatives.asMap().entrySet()) {
            Collection values = e.getValue();
            if (values.size() == 1) {
                resolvedMethods.addAll(values);
                continue;
            }
            for (ExecutableElement v2 : values) {
                if (!v2.getEnclosingElement().getKind().isClass()) continue;
                resolvedMethods.add(v2);
                continue block1;
            }
            Iterator iterator = values.iterator();
            if (!iterator.hasNext()) continue;
            ExecutableElement v = (ExecutableElement)iterator.next();
            resolvedMethods.add(v);
        }
        return resolvedMethods;
    }

    static boolean isJavaLangObject(TypeElement element) {
        return element.getQualifiedName().contentEquals(Object.class.getName());
    }

    private static enum IsParameterlessNonstaticNonobject implements $Predicate<Element>
    {
        PREDICATE;


        @Override
        public boolean apply(Element input) {
            if (input.getKind() != ElementKind.METHOD) {
                return false;
            }
            if ($SourceOrdering.isJavaLangObject((TypeElement)input.getEnclosingElement())) {
                return false;
            }
            ExecutableElement element = (ExecutableElement)input;
            boolean parameterless = element.getParameters().isEmpty();
            boolean nonstatic = !element.getModifiers().contains((Object)Modifier.STATIC);
            return parameterless && nonstatic;
        }
    }

    private static enum ToSimpleName implements $Function<Element, String>
    {
        FUNCTION;


        @Override
        public String apply(Element input) {
            return input.getSimpleName().toString();
        }
    }

    private static class BottomUpOrdering
    extends TraversalOrdering {
        private BottomUpOrdering() {
        }

        @Override
        void traverse(@Nullable TypeElement element, Set<TypeElement> linearizedTypes) {
            if (element == null || $SourceOrdering.isJavaLangObject(element)) {
                return;
            }
            linearizedTypes.add(element);
            this.traverseSuperclass(element, linearizedTypes);
            this.traverseInterfaces(element, linearizedTypes);
        }
    }

    private static class TopDownOrdering
    extends TraversalOrdering {
        private TopDownOrdering() {
        }

        @Override
        void traverse(@Nullable TypeElement element, Set<TypeElement> linearizedTypes) {
            if (element == null || $SourceOrdering.isJavaLangObject(element)) {
                return;
            }
            this.traverseInterfaces(element, linearizedTypes);
            this.traverseSuperclass(element, linearizedTypes);
            linearizedTypes.add(element);
        }
    }

    private static abstract class TraversalOrdering {
        private TraversalOrdering() {
        }

        abstract void traverse(@Nullable TypeElement var1, Set<TypeElement> var2);

        Set<TypeElement> traverseElements(@Nullable TypeElement element) {
            LinkedHashSet<TypeElement> linearizedTypes = new LinkedHashSet<TypeElement>();
            this.traverse(element, linearizedTypes);
            return linearizedTypes;
        }

        final void traverseInterfaces(TypeElement element, Set<TypeElement> linearizedTypes) {
            for (TypeMirror typeMirror : element.getInterfaces()) {
                this.traverse(this.toElement(typeMirror), linearizedTypes);
            }
        }

        final void traverseSuperclass(TypeElement element, Set<TypeElement> linearizedTypes) {
            if (element.getKind().isClass()) {
                this.traverse(this.toElement(element.getSuperclass()), linearizedTypes);
            }
        }

        @Nullable
        TypeElement toElement(TypeMirror type) {
            if (type.getKind() == TypeKind.DECLARED) {
                return (TypeElement)((DeclaredType)type).asElement();
            }
            if (type.getKind() == TypeKind.ERROR) {
                try {
                    return (TypeElement)((DeclaredType)type).asElement();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static interface AccessorProvider {
        public $ImmutableListMultimap<String, TypeElement> accessorMapping();

        public $ImmutableList<ExecutableElement> get();
    }

    private static class EclipseCompilerOrderingProvider
    implements OrderingProvider,
    $Function<Element, Object> {
        private EclipseCompilerOrderingProvider() {
        }

        @Override
        public Object apply(Element input) {
            return ((ElementImpl)input)._binding;
        }

        @Override
        public $Ordering<Element> enclosedBy(Element element) {
            if (element instanceof ElementImpl && $Iterables.all(element.getEnclosedElements(), $Predicates.instanceOf(ElementImpl.class))) {
                ElementImpl implementation = (ElementImpl)element;
                if (implementation._binding instanceof SourceTypeBinding) {
                    SourceTypeBinding sourceBinding = (SourceTypeBinding)implementation._binding;
                    return $Ordering.natural().onResultOf($Functions.compose(this.bindingsToSourceOrder(sourceBinding), this));
                }
            }
            return DEFAULT_PROVIDER.enclosedBy(element);
        }

        private $Function<Object, Integer> bindingsToSourceOrder(SourceTypeBinding sourceBinding) {
            IdentityHashMap<Object, Integer> bindings = $Maps.newIdentityHashMap();
            if (sourceBinding.scope.referenceContext.methods != null) {
                for (AbstractMethodDeclaration abstractMethodDeclaration : sourceBinding.scope.referenceContext.methods) {
                    bindings.put(abstractMethodDeclaration.binding, abstractMethodDeclaration.declarationSourceStart);
                }
            }
            if (sourceBinding.scope.referenceContext.fields != null) {
                for (AbstractMethodDeclaration abstractMethodDeclaration : sourceBinding.scope.referenceContext.fields) {
                    bindings.put(abstractMethodDeclaration.binding, abstractMethodDeclaration.declarationSourceStart);
                }
            }
            if (sourceBinding.scope.referenceContext.memberTypes != null) {
                for (AbstractMethodDeclaration abstractMethodDeclaration : sourceBinding.scope.referenceContext.memberTypes) {
                    bindings.put(abstractMethodDeclaration.binding, abstractMethodDeclaration.declarationSourceStart);
                }
            }
            return $Functions.forMap(bindings);
        }
    }

    private static interface OrderingProvider {
        public $Ordering<Element> enclosedBy(Element var1);
    }
}

