/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.ast;

import org.htmlunit.corejs.javascript.ast.InfixExpression;

public class ObjectProperty
extends InfixExpression {
    private boolean shorthand;

    public void setNodeType(int nodeType) {
        if (nodeType != 107 && nodeType != 156 && nodeType != 157 && nodeType != 168) {
            throw new IllegalArgumentException("invalid node type: " + nodeType);
        }
        this.setType(nodeType);
    }

    public ObjectProperty() {
        this.type = 107;
    }

    public ObjectProperty(int pos) {
        super(pos);
        this.type = 107;
    }

    public ObjectProperty(int pos, int len) {
        super(pos, len);
        this.type = 107;
    }

    public void setIsGetterMethod() {
        this.type = 156;
    }

    public boolean isGetterMethod() {
        return this.type == 156;
    }

    public void setIsSetterMethod() {
        this.type = 157;
    }

    public boolean isSetterMethod() {
        return this.type == 157;
    }

    public void setIsNormalMethod() {
        this.type = 168;
    }

    public boolean isNormalMethod() {
        return this.type == 168;
    }

    public boolean isMethod() {
        return this.isGetterMethod() || this.isSetterMethod() || this.isNormalMethod();
    }

    public void setIsShorthand(boolean shorthand) {
        this.shorthand = shorthand;
    }

    public boolean isShorthand() {
        return this.shorthand;
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth + 1));
        if (this.isGetterMethod()) {
            sb.append("get ");
        } else if (this.isSetterMethod()) {
            sb.append("set ");
        }
        sb.append(this.left.toSource(this.getType() == 107 ? 0 : depth));
        if (!this.shorthand) {
            if (this.type == 107) {
                sb.append(": ");
            }
            sb.append(this.right.toSource(this.getType() == 107 ? 0 : depth + 1));
        }
        return sb.toString();
    }
}

