/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.CommonMiscLog;

class CancellableExecutionCompletableFuture<T>
extends CompletableFuture<T> {
    private final Future<?> future;

    CancellableExecutionCompletableFuture(Runnable runnable, ExecutorService executor) {
        this.future = executor.submit(new CompletingRunnable(this, runnable));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        CommonMiscLog.INSTANCE.cancellingCompletableFuture(this, mayInterruptIfRunning);
        super.cancel(mayInterruptIfRunning);
        CommonMiscLog.INSTANCE.cancellingFuture(this.future, mayInterruptIfRunning);
        boolean cancelled = this.future.cancel(mayInterruptIfRunning);
        if (!cancelled) {
            CommonMiscLog.INSTANCE.cancellingFutureFailed(this.future, mayInterruptIfRunning);
        }
        return cancelled;
    }

    private static class CompletingRunnable<T>
    implements Runnable {
        private final CompletableFuture<T> future;
        private final Runnable delegate;

        private CompletingRunnable(CompletableFuture<T> future, Runnable delegate) {
            this.future = future;
            this.delegate = delegate;
        }

        public String toString() {
            return "CompletingRunnable[future=" + String.valueOf(this.future) + ", delegate=" + String.valueOf(this.delegate) + "]";
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
                this.future.complete(null);
            }
            catch (Throwable t) {
                if (this.future.isCancelled()) {
                    Futures.getThrowableNow(this.future).addSuppressed(t);
                }
                this.future.completeExceptionally(t);
            }
        }
    }
}

