/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.tenancy.spi;

import java.util.Objects;
import org.hibernate.search.mapper.pojo.logging.impl.FormattingLog;
import org.hibernate.search.mapper.pojo.tenancy.TenantIdentifierConverter;
import org.hibernate.search.util.common.annotation.Incubating;

@Incubating
public class StringTenantIdentifierConverter
implements TenantIdentifierConverter {
    public static final StringTenantIdentifierConverter INSTANCE = new StringTenantIdentifierConverter();
    public static final String NAME = "string-tenant-identifier-converter";

    @Override
    public String toStringValue(Object tenantId) {
        if (tenantId == null) {
            return null;
        }
        if (!(tenantId instanceof CharSequence)) {
            throw FormattingLog.INSTANCE.nonStringTenantId(tenantId);
        }
        return Objects.toString(tenantId);
    }

    @Override
    public Object fromStringValue(String tenantId) {
        return tenantId;
    }
}

