/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.engine.common.tree.TreeFilterDefinition;
import org.hibernate.search.engine.common.tree.spi.TreeNestingContext;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.ProjectionCollectorProviderFactory;
import org.hibernate.search.engine.search.projection.definition.ProjectionDefinition;
import org.hibernate.search.engine.search.projection.definition.spi.CompositeProjectionDefinition;
import org.hibernate.search.engine.search.projection.definition.spi.ConstantProjectionDefinition;
import org.hibernate.search.engine.search.projection.definition.spi.ObjectProjectionDefinition;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.PojoMapperMiscLog;
import org.hibernate.search.mapper.pojo.logging.impl.ProjectionLog;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.model.PojoModelConstructorParameter;
import org.hibernate.search.mapper.pojo.model.PojoModelValue;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelConstructorParameterRootElement;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelValueElement;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingContext;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingMultiContext;
import org.hibernate.search.mapper.pojo.search.definition.binding.builtin.FieldProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.builtin.ObjectProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.impl.PojoConstructorParameterProjectionMappingElement;
import org.hibernate.search.mapper.pojo.search.definition.binding.impl.ProjectionConstructorBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.impl.ProjectionConstructorParameterBinder;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.AbstractCloser;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public class ProjectionBindingContextImpl<P>
implements ProjectionBindingContext {
    private static final BiFunction<MappingElement, String, SearchException> CYCLIC_RECURSION_EXCEPTION_FACTORY = (mappingElement, cyclicRecursionPath) -> ProjectionLog.INSTANCE.objectProjectionCyclicRecursion((MappingElement)mappingElement, mappingElement.eventContext(), (String)cyclicRecursionPath);
    private static final Set<String> CONTAINER_EXTRACTORS = Set.of("array-object", "array-char", "array-boolean", "array-byte", "array-short", "array-int", "array-long", "array-float", "array-double", "collection", "iterable", "optional", "optional-double", "optional-int", "optional-long");
    private static final Set<String> MULTI_EXTRACTORS = Set.of("collection", "iterable");
    private final PojoMappingHelper mappingHelper;
    final ProjectionConstructorParameterBinder<P> parameterBinder;
    private final Map<String, Object> params;
    private final PojoTypeModel<?> parameterTypeModel;
    private final PojoModelConstructorParameterRootElement<P> parameterRootElement;
    private final ProjectionCollectorProviderFactory projectionCollectorProviderFactory;
    private MappingElement mappingElement;
    private PartialBinding<P> partialBinding;

    ProjectionBindingContextImpl(ProjectionConstructorParameterBinder<P> parameterBinder, Map<String, Object> params) {
        this.mappingHelper = parameterBinder.mappingHelper;
        this.parameterBinder = parameterBinder;
        this.params = params;
        this.parameterTypeModel = parameterBinder.parameter.typeModel();
        this.parameterRootElement = parameterBinder.parameterRootElement;
        this.projectionCollectorProviderFactory = new BuiltInProjectionCollectorProviderFactory();
    }

    @Override
    public BeanResolver beanResolver() {
        return this.mappingHelper.beanResolver();
    }

    @Override
    public <T> T param(String name, Class<T> paramType) {
        Contracts.assertNotNull((Object)name, (String)"name");
        Contracts.assertNotNull(paramType, (String)"paramType");
        Object value = this.params.get(name);
        if (value == null) {
            throw PojoMapperMiscLog.INSTANCE.paramNotDefined(name);
        }
        return paramType.cast(value);
    }

    @Override
    public <T> Optional<T> paramOptional(String name, Class<T> paramType) {
        Contracts.assertNotNull((Object)name, (String)"name");
        Contracts.assertNotNull(paramType, (String)"paramType");
        return Optional.ofNullable(this.params.get(name)).map(paramType::cast);
    }

    public <P2, C> void definition(Class<P2> expectedValueType, ProjectionDefinition<? extends C> definition) {
        this.definition(expectedValueType, (BeanHolder<? extends ProjectionDefinition<? extends C>>)BeanHolder.of(definition));
    }

    public <P2, C> void definition(Class<P2> expectedValueType, BeanHolder<? extends ProjectionDefinition<? extends C>> definitionHolder) {
        this.checkAndBind(definitionHolder, this.mappingHelper.introspector().typeModel(expectedValueType));
    }

    @Deprecated(since="8.0")
    public Optional<MultiContextImpl<?>> multi() {
        PojoTypeModel<?> boundParameterElement = this.boundParameterElement(MULTI_EXTRACTORS);
        if (boundParameterElement == null) {
            return Optional.empty();
        }
        if (!this.mappingHelper.introspector().typeModel(List.class).isSubTypeOf(this.parameterTypeModel.rawType())) {
            throw ProjectionLog.INSTANCE.invalidMultiValuedParameterTypeForProjectionConstructor(this.parameterTypeModel);
        }
        return Optional.of(new MultiContextImpl(boundParameterElement));
    }

    private PojoTypeModel<?> boundParameterElement(Set<String> extractors) {
        BoundContainerExtractorPath<?, ?> boundParameterElementPath = this.mappingHelper.indexModelBinder().bindExtractorPath(this.parameterTypeModel, ContainerExtractorPath.defaultExtractors());
        List<String> boundParameterElementExtractorNames = boundParameterElementPath.getExtractorPath().explicitExtractorNames();
        if (boundParameterElementExtractorNames.isEmpty()) {
            return null;
        }
        if (boundParameterElementExtractorNames.size() > 1 || !extractors.contains(boundParameterElementExtractorNames.get(0))) {
            throw ProjectionLog.INSTANCE.invalidMultiValuedParameterTypeForProjectionConstructor(this.parameterTypeModel);
        }
        return boundParameterElementPath.getExtractedType();
    }

    @Override
    public PojoModelConstructorParameter constructorParameter() {
        return this.parameterRootElement;
    }

    @Override
    public Optional<PojoModelValue<?>> containerElement() {
        return this.containerElementModel().map(this::getPojoModelValueElement);
    }

    private PojoModelValueElement<?> getPojoModelValueElement(PojoTypeModel<?> m) {
        return new PojoModelValueElement(this.mappingHelper.introspector(), m);
    }

    private Optional<PojoTypeModel<?>> containerElementModel() {
        PojoTypeModel<?> boundParameterElement = this.boundParameterElement(CONTAINER_EXTRACTORS);
        if (boundParameterElement == null) {
            return Optional.empty();
        }
        return Optional.of(boundParameterElement);
    }

    @Override
    public <C, T> BeanHolder<? extends ProjectionDefinition<C>> createObjectDefinition(String fieldPath, Class<T> projectedType, TreeFilterDefinition filter, ProjectionCollector.Provider<T, C> collector) {
        Contracts.assertNotNull((Object)fieldPath, (String)"fieldPath");
        Contracts.assertNotNull(projectedType, (String)"projectedType");
        Contracts.assertNotNull((Object)filter, (String)"filter");
        Contracts.assertNotNull(collector, (String)"collector");
        Optional<BeanHolder> objectProjection = this.nestObjectProjection(fieldPath, filter, nestingContext -> {
            CompositeProjectionDefinition composite = this.createCompositeProjectionDefinition(projectedType, (TreeNestingContext)nestingContext);
            try {
                return BeanHolder.ofCloseable((AutoCloseable)new ObjectProjectionDefinition.WrappedValued(fieldPath, composite, collector));
            }
            catch (RuntimeException e) {
                new SuppressingCloser((Throwable)e).push(composite);
                throw e;
            }
        });
        return objectProjection.orElse(ConstantProjectionDefinition.empty(collector));
    }

    private <T> Optional<T> nestObjectProjection(String fieldPath, TreeFilterDefinition filter, final Function<TreeNestingContext, T> contextBuilder) {
        return this.parameterBinder.parent.nestingContext.nestComposed(this.mappingElement, fieldPath + ".", filter, this.mappingHelper.getOrCreatePathTracker(this.mappingElement, filter), new TreeNestingContext.NestedContextBuilder<T>(){

            public void appendObject(String objectName) {
            }

            public T build(TreeNestingContext nestingContext) {
                return contextBuilder.apply(nestingContext);
            }
        }, CYCLIC_RECURSION_EXCEPTION_FACTORY);
    }

    @Override
    public <T> BeanHolder<? extends ProjectionDefinition<T>> createCompositeDefinition(Class<T> projectedType) {
        return BeanHolder.ofCloseable(this.createCompositeProjectionDefinition(projectedType, this.parameterBinder.parent.nestingContext));
    }

    private <T> CompositeProjectionDefinition<T> createCompositeProjectionDefinition(Class<T> projectedType, TreeNestingContext nestingContext) {
        PojoConstructorModel<T> projectionConstructor = this.parameterBinder.findProjectionConstructorOrNull(this.mappingHelper.introspector().typeModel(projectedType));
        if (projectionConstructor == null) {
            throw ProjectionLog.INSTANCE.invalidObjectClassForProjection(projectedType);
        }
        return new ProjectionConstructorBinder<T>(this.mappingHelper, projectionConstructor, this, nestingContext).bind();
    }

    @Override
    public boolean isIncluded(String fieldPath) {
        return (Boolean)this.parameterBinder.parent.nestingContext.nest(fieldPath, (prefixedRelativeName, inclusion) -> TreeNodeInclusion.INCLUDED.equals((Object)inclusion));
    }

    @Override
    public ProjectionCollectorProviderFactory projectionCollectorProviderFactory() {
        return this.projectionCollectorProviderFactory;
    }

    public BeanHolder<? extends ProjectionDefinition<? extends P>> applyBinder(ProjectionBinder binder) {
        try {
            this.mappingElement = new PojoConstructorParameterProjectionMappingElement(this.parameterBinder.parent.constructor, this.parameterBinder.parameter, binder);
            binder.bind(this);
            if (this.partialBinding == null) {
                throw ProjectionLog.INSTANCE.missingProjectionDefinitionForBinder(binder);
            }
            BeanHolder<ProjectionDefinition<P>> beanHolder = this.partialBinding.complete();
            return beanHolder;
        }
        catch (RuntimeException e) {
            if (this.partialBinding != null) {
                this.partialBinding.abort((AbstractCloser<?, ?>)new SuppressingCloser((Throwable)e));
            }
            throw e;
        }
        finally {
            this.partialBinding = null;
            this.mappingElement = null;
        }
    }

    private <P2, C> void checkAndBind(BeanHolder<? extends ProjectionDefinition<? extends C>> definitionHolder, PojoRawTypeModel<P2> expectedValueType) {
        Optional<PojoTypeModel<?>> containerElementModel = this.containerElementModel();
        if (containerElementModel.isPresent()) {
            if (!expectedValueType.isSubTypeOf(containerElementModel.get().rawType())) {
                throw ProjectionLog.INSTANCE.invalidOutputTypeForMultiValuedProjectionDefinition(definitionHolder.get(), this.parameterTypeModel, expectedValueType);
            }
        } else if (!expectedValueType.isSubTypeOf(this.parameterTypeModel.rawType())) {
            throw ProjectionLog.INSTANCE.invalidOutputTypeForProjectionDefinition(definitionHolder.get(), this.parameterTypeModel, expectedValueType);
        }
        BeanHolder<? extends ProjectionDefinition<? extends C>> castDefinitionHolder = definitionHolder;
        this.partialBinding = new PartialBinding(castDefinitionHolder);
    }

    public BeanHolder<? extends ProjectionDefinition<?>> applyDefaultProjection() {
        Optional<PojoTypeModel<?>> containerElement = this.containerElementModel();
        PojoConstructorModel<?> constructorModelOrNull = containerElement.isPresent() ? this.parameterBinder.findProjectionConstructorOrNull(containerElement.get().rawType()) : this.parameterBinder.findProjectionConstructorOrNull(this.parameterTypeModel.rawType());
        Optional<String> paramName = this.parameterRootElement.name();
        if (!paramName.isPresent()) {
            throw ProjectionLog.INSTANCE.missingParameterNameForInferredProjection();
        }
        if (constructorModelOrNull != null) {
            return this.applyBinder(ObjectProjectionBinder.create(paramName.get()));
        }
        return this.applyBinder(FieldProjectionBinder.create(paramName.get()));
    }

    private class BuiltInProjectionCollectorProviderFactory
    implements ProjectionCollectorProviderFactory {
        private BuiltInProjectionCollectorProviderFactory() {
        }

        public <R, U> ProjectionCollector.Provider<U, R> projectionCollectorProvider(Class<R> containerType, Class<U> containerElementType) {
            ProjectionCollector.Provider reference;
            if (containerType == null) {
                reference = ProjectionCollector.nullable();
            } else if (List.class.isAssignableFrom(containerType)) {
                reference = ProjectionCollector.list();
            } else if (SortedSet.class.isAssignableFrom(containerType)) {
                if (!Comparable.class.isAssignableFrom(containerElementType)) {
                    throw ProjectionLog.INSTANCE.cannotBindSortedSetWithNonComparableElements(containerElementType, ProjectionBindingContextImpl.this.mappingElement.eventContext());
                }
                reference = ProjectionCollector.sortedSet();
            } else if (Set.class.isAssignableFrom(containerType)) {
                reference = ProjectionCollector.set();
            } else if (containerType.isArray()) {
                reference = ProjectionCollector.array(containerElementType);
            } else if (Collection.class.isAssignableFrom(containerType) || Iterable.class.isAssignableFrom(containerType)) {
                reference = ProjectionCollector.list();
            } else {
                throw ProjectionLog.INSTANCE.invalidMultiValuedParameterTypeForProjectionConstructor(ProjectionBindingContextImpl.this.parameterTypeModel);
            }
            return reference;
        }
    }

    @Deprecated(since="8.0")
    public class MultiContextImpl<PV>
    implements ProjectionBindingMultiContext {
        public final PojoTypeModel<PV> parameterContainerElementTypeModel;
        private final PojoModelValue<PV> parameterContainerElementRootElement;

        public MultiContextImpl(PojoTypeModel<PV> parameterContainerElementTypeModel) {
            this.parameterContainerElementTypeModel = parameterContainerElementTypeModel;
            this.parameterContainerElementRootElement = new PojoModelValueElement<PV>(ProjectionBindingContextImpl.this.mappingHelper.introspector(), parameterContainerElementTypeModel);
        }

        public <P2> void definition(Class<P2> expectedValueType, ProjectionDefinition<? extends List<? extends P2>> definition) {
            this.definition(expectedValueType, (BeanHolder<? extends ProjectionDefinition<? extends List<? extends P2>>>)BeanHolder.of(definition));
        }

        public <P2> void definition(Class<P2> expectedValueType, BeanHolder<? extends ProjectionDefinition<? extends List<? extends P2>>> definitionHolder) {
            ProjectionBindingContextImpl.this.checkAndBind(definitionHolder, ProjectionBindingContextImpl.this.mappingHelper.introspector().typeModel(expectedValueType));
        }

        public PojoModelValue<PV> containerElement() {
            return this.parameterContainerElementRootElement;
        }
    }

    private static class PartialBinding<P> {
        private final BeanHolder<? extends ProjectionDefinition<? extends P>> definitionHolder;

        private PartialBinding(BeanHolder<? extends ProjectionDefinition<? extends P>> definitionHolder) {
            this.definitionHolder = definitionHolder;
        }

        void abort(AbstractCloser<?, ?> closer) {
            closer.push(BeanHolder::close, this.definitionHolder);
        }

        BeanHolder<? extends ProjectionDefinition<? extends P>> complete() {
            return this.definitionHolder;
        }
    }
}

