/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.builtin;

import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.definition.spi.ConstantProjectionDefinition;
import org.hibernate.search.engine.search.projection.definition.spi.DistanceProjectionDefinition;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.mapper.pojo.logging.impl.ProjectionLog;
import org.hibernate.search.mapper.pojo.model.PojoModelValue;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingContext;
import org.hibernate.search.util.common.impl.Contracts;

public final class DistanceProjectionBinder
implements ProjectionBinder {
    private final String fieldPathOrNull;
    private final String parameterName;
    private DistanceUnit unit = DistanceUnit.METERS;

    public static DistanceProjectionBinder create(String parameterName) {
        return DistanceProjectionBinder.create(null, parameterName);
    }

    public static DistanceProjectionBinder create(String fieldPath, String parameterName) {
        return new DistanceProjectionBinder(fieldPath, parameterName);
    }

    private DistanceProjectionBinder(String fieldPathOrNull, String parameterName) {
        this.fieldPathOrNull = fieldPathOrNull;
        this.parameterName = parameterName;
    }

    public DistanceProjectionBinder unit(DistanceUnit unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public void bind(ProjectionBindingContext context) {
        Class<?> containerClass;
        Contracts.assertNotNullNorEmpty((String)this.parameterName, (String)"parameterName");
        Optional<PojoModelValue<?>> containerElementOptional = context.containerElement();
        String fieldPath = this.fieldPathOrFail(context);
        if (containerElementOptional.isPresent()) {
            PojoModelValue<?> containerElement = containerElementOptional.get();
            if (!containerElement.rawType().isAssignableFrom(Double.class)) {
                throw ProjectionLog.INSTANCE.invalidParameterTypeForDistanceProjectionInProjectionConstructor(containerElement.rawType(), "SomeContainer<Double>");
            }
            containerClass = context.constructorParameter().rawType();
        } else {
            if (!context.constructorParameter().rawType().isAssignableFrom(Double.class)) {
                throw ProjectionLog.INSTANCE.invalidParameterTypeForDistanceProjectionInProjectionConstructor(context.constructorParameter().rawType(), "Double");
            }
            containerClass = null;
        }
        ProjectionCollector.Provider collector = context.projectionCollectorProviderFactory().projectionCollectorProvider(containerClass, Double.class);
        this.bind(context, fieldPath, collector);
    }

    private void bind(ProjectionBindingContext context, String fieldPath, ProjectionCollector.Provider<Double, ?> collector) {
        context.definition(Double.class, context.isIncluded(fieldPath) ? BeanHolder.of((Object)new DistanceProjectionDefinition.WrappedValued(fieldPath, this.parameterName, this.unit, collector)) : ConstantProjectionDefinition.empty(collector));
    }

    private String fieldPathOrFail(ProjectionBindingContext context) {
        if (this.fieldPathOrNull != null) {
            return this.fieldPathOrNull;
        }
        Optional<String> paramName = context.constructorParameter().name();
        if (paramName.isEmpty()) {
            throw ProjectionLog.INSTANCE.missingParameterNameForFieldProjectionInProjectionConstructor();
        }
        return paramName.get();
    }
}

