/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.scope.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.engine.backend.scope.IndexScopeExtension;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScope;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScopeBuilder;
import org.hibernate.search.engine.search.aggregation.dsl.TypedSearchAggregationFactory;
import org.hibernate.search.engine.search.highlighter.dsl.SearchHighlighterFactory;
import org.hibernate.search.engine.search.predicate.dsl.TypedSearchPredicateFactory;
import org.hibernate.search.engine.search.projection.dsl.TypedSearchProjectionFactory;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.engine.search.sort.dsl.TypedSearchSortFactory;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContextBuilder;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoDefaultMassIndexer;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexer;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingContext;
import org.hibernate.search.mapper.pojo.schema.management.impl.PojoScopeSchemaManagerImpl;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContext;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeTypeContextProvider;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeSessionContext;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeTypeExtendedContextProvider;
import org.hibernate.search.mapper.pojo.search.loading.impl.PojoSearchLoadingContextBuilder;
import org.hibernate.search.mapper.pojo.work.impl.PojoScopeWorkspaceImpl;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkspace;
import org.hibernate.search.util.common.impl.CollectionHelper;

public final class PojoScopeDelegateImpl<SR, R extends EntityReference, E, C>
implements PojoScopeDelegate<SR, R, E, C> {
    private final PojoScopeMappingContext mappingContext;
    private final Class<SR> rootScope;
    private final PojoScopeTypeContextProvider indexedTypeContextProvider;
    private final Set<? extends PojoScopeIndexedTypeContext<?, ? extends E>> targetedTypeContexts;
    private final Set<C> targetedTypeExtendedContexts;
    private MappedIndexScope<SR, R, E> delegate;

    public static <SR, R extends EntityReference, E, C> PojoScopeDelegate<SR, R, E, C> create(PojoScopeMappingContext mappingContext, Class<SR> rootScope, PojoScopeTypeContextProvider typeContextProvider, Set<? extends PojoScopeIndexedTypeContext<?, ? extends E>> targetedTypeContexts, PojoScopeTypeExtendedContextProvider<E, C> indexedTypeExtendedContextProvider) {
        Set targetedTypeExtendedContexts = targetedTypeContexts.stream().map(PojoLoadingTypeContext::typeIdentifier).map(indexedTypeExtendedContextProvider::forExactType).collect(Collectors.toCollection(LinkedHashSet::new));
        return new PojoScopeDelegateImpl<SR, R, E, C>(mappingContext, rootScope, typeContextProvider, targetedTypeContexts, targetedTypeExtendedContexts);
    }

    private PojoScopeDelegateImpl(PojoScopeMappingContext mappingContext, Class<SR> rootScope, PojoScopeTypeContextProvider indexedTypeContextProvider, Set<? extends PojoScopeIndexedTypeContext<?, ? extends E>> targetedTypeContexts, Set<C> targetedTypeExtendedContexts) {
        this.mappingContext = mappingContext;
        this.rootScope = rootScope;
        this.indexedTypeContextProvider = indexedTypeContextProvider;
        this.targetedTypeContexts = targetedTypeContexts;
        this.targetedTypeExtendedContexts = Collections.unmodifiableSet(targetedTypeExtendedContexts);
    }

    @Override
    public Set<C> includedIndexedTypes() {
        return this.targetedTypeExtendedContexts;
    }

    @Override
    public <LOS> SearchQuerySelectStep<SR, ?, R, E, LOS, TypedSearchProjectionFactory<SR, R, E>, ?> search(PojoScopeSessionContext sessionContext, PojoSelectionLoadingContextBuilder<LOS> loadingContextBuilder) {
        LinkedHashMap targetTypesByEntityName = new LinkedHashMap();
        for (PojoScopeIndexedTypeContext<?, E> type : this.targetedTypeContexts) {
            targetTypesByEntityName.put(type.entityName(), type);
        }
        return this.getIndexScope().search((BackendSessionContext)sessionContext, new PojoSearchLoadingContextBuilder(targetTypesByEntityName, sessionContext.mappingContext().entityReferenceFactoryDelegate(), sessionContext, loadingContextBuilder));
    }

    @Override
    public TypedSearchPredicateFactory<SR> predicate() {
        return this.getIndexScope().predicate();
    }

    @Override
    public TypedSearchSortFactory<SR> sort() {
        return this.getIndexScope().sort();
    }

    @Override
    public TypedSearchProjectionFactory<SR, R, E> projection() {
        return this.getIndexScope().projection();
    }

    @Override
    public TypedSearchAggregationFactory<SR> aggregation() {
        return this.getIndexScope().aggregation();
    }

    @Override
    public SearchHighlighterFactory highlighter() {
        return this.getIndexScope().highlighter();
    }

    @Override
    public PojoScopeWorkspace workspace(String tenantId) {
        return new PojoScopeWorkspaceImpl(this.mappingContext, this.targetedTypeContexts, CollectionHelper.asSetIgnoreNull((Object[])new String[]{tenantId}));
    }

    @Override
    public PojoScopeWorkspace workspace(Set<String> tenantIds) {
        return new PojoScopeWorkspaceImpl(this.mappingContext, this.targetedTypeContexts, tenantIds);
    }

    @Override
    public PojoScopeSchemaManager schemaManager() {
        return new PojoScopeSchemaManagerImpl(this.targetedTypeContexts);
    }

    @Override
    public PojoMassIndexer massIndexer(PojoMassIndexingContext context) {
        return new PojoDefaultMassIndexer(context, this.mappingContext, this.indexedTypeContextProvider, this.targetedTypeContexts, this.schemaManager(), this);
    }

    @Override
    public <T> T extension(IndexScopeExtension<T> extension) {
        return (T)this.getIndexScope().extension(extension);
    }

    private MappedIndexScope<SR, R, E> getIndexScope() {
        if (this.delegate == null) {
            Iterator<PojoScopeIndexedTypeContext<?, E>> iterator = this.targetedTypeContexts.iterator();
            MappedIndexScopeBuilder builder = iterator.next().createScopeBuilder(this.mappingContext, this.rootScope);
            while (iterator.hasNext()) {
                iterator.next().addTo(builder);
            }
            this.delegate = builder.build();
        }
        return this.delegate;
    }
}

