/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.search.engine.tenancy.spi.TenancyMode;
import org.hibernate.search.mapper.pojo.logging.impl.MassIndexingLog;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingDefaultCleanOperation;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingEnvironment;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingFailureHandler;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingMonitor;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingBatchCoordinator;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingDelegatingFailureHandler;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingFailSafeFailureHandlerWrapper;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeGroup;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingLoggingMonitor;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingNotifier;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingTypeContextProvider;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexer;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingMappingContext;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.util.common.impl.Futures;

public class PojoDefaultMassIndexer
implements PojoMassIndexer {
    private static final MassIndexingEnvironment DO_NOTHING_ENVIRONMENT = new MassIndexingEnvironment(){

        @Override
        public void beforeExecution(MassIndexingEnvironment.Context context) {
        }

        @Override
        public void afterExecution(MassIndexingEnvironment.Context context) {
        }
    };
    private final PojoMassIndexingContext massIndexingContext;
    private final PojoMassIndexingMappingContext mappingContext;
    private final PojoMassIndexingTypeContextProvider typeContextProvider;
    private final Set<? extends PojoMassIndexingIndexedTypeContext<?>> targetedIndexedTypes;
    private final PojoScopeSchemaManager scopeSchemaManager;
    private final PojoScopeDelegate<?, ?, ?, ?> pojoScopeDelegate;
    private int typesToIndexInParallel = 1;
    private int documentBuilderThreads = 6;
    private Boolean mergeSegmentsOnFinish;
    private Boolean dropAndCreateSchemaOnStart;
    private Boolean purgeAtStart;
    private Boolean mergeSegmentsAfterPurge;
    private Boolean failFast;
    private Long failureFloodingThreshold = null;
    private MassIndexingFailureHandler failureHandler;
    private MassIndexingMonitor monitor;
    private MassIndexingEnvironment environment;

    public PojoDefaultMassIndexer(PojoMassIndexingContext massIndexingContext, PojoMassIndexingMappingContext mappingContext, PojoMassIndexingTypeContextProvider typeContextProvider, Set<? extends PojoMassIndexingIndexedTypeContext<?>> targetedIndexedTypes, PojoScopeSchemaManager scopeSchemaManager, PojoScopeDelegate<?, ?, ?, ?> pojoScopeDelegate) {
        this.massIndexingContext = massIndexingContext;
        this.mappingContext = mappingContext;
        this.typeContextProvider = typeContextProvider;
        this.targetedIndexedTypes = targetedIndexedTypes;
        this.scopeSchemaManager = scopeSchemaManager;
        this.pojoScopeDelegate = pojoScopeDelegate;
    }

    @Override
    public PojoDefaultMassIndexer typesToIndexInParallel(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.typesToIndexInParallel = numberOfThreads;
        return this;
    }

    @Override
    public PojoDefaultMassIndexer threadsToLoadObjects(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.documentBuilderThreads = numberOfThreads;
        return this;
    }

    @Override
    public PojoDefaultMassIndexer mergeSegmentsOnFinish(boolean enable) {
        this.mergeSegmentsOnFinish = enable;
        return this;
    }

    @Override
    public PojoDefaultMassIndexer mergeSegmentsAfterPurge(boolean enable) {
        this.mergeSegmentsAfterPurge = enable;
        return this;
    }

    @Override
    public PojoDefaultMassIndexer dropAndCreateSchemaOnStart(boolean enable) {
        this.dropAndCreateSchemaOnStart = enable;
        return this;
    }

    @Override
    public PojoDefaultMassIndexer purgeAllOnStart(boolean enable) {
        this.purgeAtStart = enable;
        return this;
    }

    @Override
    public PojoDefaultMassIndexer monitor(MassIndexingMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> start() {
        PojoMassIndexingBatchCoordinator coordinator = this.createCoordinator();
        ThreadPoolExecutor executor = this.mappingContext.threadPoolProvider().newFixedThreadPool(1, "Mass indexing - Coordinator");
        try {
            CompletableFuture completableFuture = Futures.runAsync((Runnable)coordinator, (ExecutorService)executor);
            return completableFuture;
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public void startAndWait() throws InterruptedException {
        PojoMassIndexingBatchCoordinator coordinator = this.createCoordinator();
        try {
            coordinator.run();
        }
        catch (Throwable t) {
            if (Thread.interrupted()) {
                InterruptedException exception = new InterruptedException();
                exception.addSuppressed(t);
                throw exception;
            }
            throw t;
        }
    }

    private PojoMassIndexingBatchCoordinator createCoordinator() {
        boolean actualDropAndCreateSchemaOnStart;
        List<PojoMassIndexingIndexedTypeGroup<?>> typeGroupsToIndex = PojoMassIndexingIndexedTypeGroup.disjoint(this.mappingContext, this.typeContextProvider, this.targetedIndexedTypes, this.massIndexingContext);
        this.typesToIndexInParallel = Math.min(this.typesToIndexInParallel, typeGroupsToIndex.size());
        PojoMassIndexingNotifier notifier = new PojoMassIndexingNotifier(this.getOrCreateFailureHandler(), this.getOrCreateMonitor(), this.failureFloodingThreshold);
        if (this.dropAndCreateSchemaOnStart == null && this.purgeAtStart == null) {
            MassIndexingDefaultCleanOperation operation = this.massIndexingContext.massIndexingDefaultCleanOperation();
            this.purgeAtStart = MassIndexingDefaultCleanOperation.PURGE.equals((Object)operation);
            this.dropAndCreateSchemaOnStart = MassIndexingDefaultCleanOperation.DROP_AND_CREATE.equals((Object)operation);
        }
        if (actualDropAndCreateSchemaOnStart = Boolean.TRUE.equals(this.dropAndCreateSchemaOnStart)) {
            if (Boolean.TRUE.equals(this.purgeAtStart)) {
                MassIndexingLog.INSTANCE.redundantPurgeAfterDrop();
            }
            if (TenancyMode.MULTI_TENANCY.equals((Object)this.massIndexingContext.tenancyMode())) {
                throw MassIndexingLog.INSTANCE.schemaDropNotAllowedWithMultitenancy(this.massIndexingContext.tenantIds());
            }
        }
        return new PojoMassIndexingBatchCoordinator(this.mappingContext, notifier, typeGroupsToIndex, this.massIndexingContext, this.scopeSchemaManager, this.pojoScopeDelegate, this.resolvedMassIndexingEnvironment(), this.typesToIndexInParallel, this.documentBuilderThreads, this.mergeSegmentsOnFinish, actualDropAndCreateSchemaOnStart, this.purgeAtStart == null ? !actualDropAndCreateSchemaOnStart : this.purgeAtStart, this.mergeSegmentsAfterPurge);
    }

    @Override
    public PojoDefaultMassIndexer failureHandler(MassIndexingFailureHandler failureHandler) {
        this.failureHandler = failureHandler;
        return this;
    }

    @Override
    public PojoMassIndexer environment(MassIndexingEnvironment environment) {
        this.environment = environment;
        return this;
    }

    @Override
    public PojoMassIndexer failureFloodingThreshold(long threshold) {
        this.failureFloodingThreshold = threshold;
        return this;
    }

    @Override
    public PojoMassIndexer failFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    private MassIndexingFailureHandler getOrCreateFailureHandler() {
        MassIndexingFailureHandler handler = this.failureHandler;
        if (handler == null) {
            handler = new PojoMassIndexingDelegatingFailureHandler(this.mappingContext.failureHandler());
        }
        return new PojoMassIndexingFailSafeFailureHandlerWrapper(handler, Boolean.TRUE.equals(this.failFast));
    }

    private MassIndexingMonitor getOrCreateMonitor() {
        if (this.monitor != null) {
            return this.monitor;
        }
        return new PojoMassIndexingLoggingMonitor();
    }

    private MassIndexingEnvironment resolvedMassIndexingEnvironment() {
        return this.environment != null ? this.environment : DO_NOTHING_ENVIRONMENT;
    }
}

