/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.util.List;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierSink;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassLoadingContext;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingType;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingTypeGroupMonitorContext;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingTypeGroupMonitorCreateContext;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeGroup;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingContext;
import org.hibernate.search.util.common.AssertionFailure;

class MassIndexingTypeGroupContext<E>
implements MassIndexingTypeGroupMonitorCreateContext,
MassIndexingTypeGroupMonitorContext {
    private final Set<MassIndexingType> includedTypes;
    private final PojoMassIndexingIndexedTypeGroup<E> typeGroup;
    private final PojoMassIndexingContext massIndexingContext;
    private final String tenantId;

    public MassIndexingTypeGroupContext(PojoMassIndexingIndexedTypeGroup<E> typeGroup, PojoMassIndexingContext massIndexingContext, String tenantId) {
        this.includedTypes = typeGroup.includedTypes().stream().map(PojoLoadingTypeContext::entityName).map(MassIndexingTypeImpl::new).collect(Collectors.toSet());
        this.typeGroup = typeGroup;
        this.massIndexingContext = massIndexingContext;
        this.tenantId = tenantId;
    }

    PojoMassIndexingContext massIndexingContext() {
        return this.massIndexingContext;
    }

    @Override
    public Set<MassIndexingType> includedTypes() {
        return this.includedTypes;
    }

    @Override
    public OptionalLong totalCount() {
        try (PojoMassIdentifierLoader loader = this.createLoader();){
            OptionalLong optionalLong = loader.totalCount();
            return optionalLong;
        }
    }

    private PojoMassIdentifierLoader createLoader() {
        return this.typeGroup.loadingStrategy().createIdentifierLoader(this.typeGroup.includedTypes(), new DummyIdentifierLoadingContext());
    }

    public String tenantIdentifier() {
        return this.tenantId;
    }

    public MassIndexingTypeGroupMonitorContext withIdentifierLoader(PojoMassIdentifierLoader loader) {
        return loader::totalCount;
    }

    private class DummyIdentifierLoadingContext<I>
    implements PojoMassIdentifierLoadingContext<I> {
        private DummyIdentifierLoadingContext() {
        }

        @Override
        public PojoMassLoadingContext parent() {
            return MassIndexingTypeGroupContext.this.massIndexingContext;
        }

        @Override
        public PojoMassIdentifierSink<I> createSink() {
            return new PojoMassIdentifierSink<I>(){

                @Override
                public void accept(List<? extends I> batch) throws InterruptedException {
                    throw new AssertionFailure("An unexpected call to a sink method.");
                }

                @Override
                public void complete() {
                    throw new AssertionFailure("An unexpected call to a sink method.");
                }
            };
        }

        @Override
        public String tenantIdentifier() {
            return MassIndexingTypeGroupContext.this.tenantId;
        }
    }

    private static class MassIndexingTypeImpl
    implements MassIndexingType {
        private final String entityName;

        private MassIndexingTypeImpl(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public String entityName() {
            return this.entityName;
        }
    }
}

