/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.runtime.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.RoutingBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.DocumentRouter;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeSessionContext;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.route.DocumentRoute;
import org.hibernate.search.mapper.pojo.route.DocumentRouteDescriptor;
import org.hibernate.search.mapper.pojo.route.DocumentRoutes;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.route.impl.DocumentRouteImpl;
import org.hibernate.search.util.common.impl.Closer;

public final class RoutingBridgeDocumentRouter<E>
implements DocumentRouter<E> {
    private final BeanHolder<? extends RoutingBridge<? super E>> routingBridgeHolder;

    public RoutingBridgeDocumentRouter(BeanHolder<? extends RoutingBridge<? super E>> routingBridgeHolder) {
        this.routingBridgeHolder = routingBridgeHolder;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(RoutingBridge::close, this.routingBridgeHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.routingBridgeHolder);
        }
    }

    @Override
    public DocumentRouteDescriptor currentRoute(Object entityIdentifier, Supplier<? extends E> entitySupplier, DocumentRoutesDescriptor providedRoutes, BridgeSessionContext context) {
        return new CurrentDocumentRoutes().currentRoute(entityIdentifier, entitySupplier.get(), context);
    }

    @Override
    public DocumentRoutesDescriptor routes(Object entityIdentifier, Supplier<? extends E> entitySupplier, DocumentRoutesDescriptor providedRoutes, BridgeSessionContext context) {
        E entity = entitySupplier.get();
        DocumentRouteDescriptor currentRoute = new CurrentDocumentRoutes().currentRoute(entityIdentifier, entity, context);
        Collection<DocumentRouteDescriptor> previousRoutes = new PreviousDocumentRoutes().previousDifferentRoutes(currentRoute, entityIdentifier, entity, providedRoutes, context);
        return DocumentRoutesDescriptor.of(currentRoute, previousRoutes);
    }

    private final class CurrentDocumentRoutes
    implements DocumentRoutes {
        private DocumentRouteImpl currentRoute = null;
        private boolean skip = false;

        private CurrentDocumentRoutes() {
        }

        @Override
        public DocumentRoute addRoute() {
            if (this.currentRoute != null) {
                throw MappingLog.INSTANCE.multipleCurrentRoutes(RoutingBridgeDocumentRouter.this.routingBridgeHolder.get());
            }
            this.currentRoute = new DocumentRouteImpl();
            return this.currentRoute;
        }

        @Override
        public void notIndexed() {
            this.skip = true;
        }

        DocumentRouteDescriptor currentRoute(Object entityIdentifier, E entity, BridgeSessionContext context) {
            ((RoutingBridge)RoutingBridgeDocumentRouter.this.routingBridgeHolder.get()).route(this, entityIdentifier, entity, context.routingBridgeRouteContext());
            if (this.skip) {
                return null;
            }
            if (this.currentRoute == null) {
                throw MappingLog.INSTANCE.noCurrentRoute(RoutingBridgeDocumentRouter.this.routingBridgeHolder.get());
            }
            return this.currentRoute.toDescriptor();
        }
    }

    private final class PreviousDocumentRoutes
    implements DocumentRoutes {
        private List<DocumentRouteImpl> previousRoutes = null;
        private boolean skip = false;

        private PreviousDocumentRoutes() {
        }

        @Override
        public DocumentRoute addRoute() {
            if (this.previousRoutes == null) {
                this.previousRoutes = new ArrayList<DocumentRouteImpl>();
            }
            DocumentRouteImpl route = new DocumentRouteImpl();
            this.previousRoutes.add(route);
            return route;
        }

        @Override
        public void notIndexed() {
            this.skip = true;
        }

        Collection<DocumentRouteDescriptor> previousDifferentRoutes(DocumentRouteDescriptor currentRoute, Object entityIdentifier, E entity, DocumentRoutesDescriptor providedRoutes, BridgeSessionContext context) {
            ((RoutingBridge)RoutingBridgeDocumentRouter.this.routingBridgeHolder.get()).previousRoutes(this, entityIdentifier, entity, context.routingBridgeRouteContext());
            if (this.skip) {
                return Collections.emptyList();
            }
            if (this.previousRoutes == null || this.previousRoutes.isEmpty()) {
                throw MappingLog.INSTANCE.noPreviousRoute(RoutingBridgeDocumentRouter.this.routingBridgeHolder.get());
            }
            LinkedHashSet<DocumentRouteDescriptor> result = new LinkedHashSet<DocumentRouteDescriptor>(this.previousRoutes.size());
            if (providedRoutes != null) {
                result.addAll(providedRoutes.previousRoutes());
                DocumentRouteDescriptor providedCurrentRoute = providedRoutes.currentRoute();
                if (providedCurrentRoute != null) {
                    result.add(providedCurrentRoute);
                }
            }
            for (DocumentRouteImpl previousRoute : this.previousRoutes) {
                result.add(previousRoute.toDescriptor());
            }
            result.remove(currentRoute);
            return result;
        }
    }
}

