/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.binding.impl;

import java.util.Map;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.mapper.pojo.bridge.RoutingBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.RoutingBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.AbstractCompositeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundRoutingBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingBinder;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.model.PojoModelType;
import org.hibernate.search.mapper.pojo.model.dependency.PojoRoutingIndexingDependencyConfigurationContext;
import org.hibernate.search.mapper.pojo.model.dependency.impl.PojoRoutingIndexingDependencyConfigurationContextImpl;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelTypeRootElement;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

public class RoutingBindingContextImpl<E>
extends AbstractCompositeBindingContext
implements RoutingBindingContext {
    private final PojoBootstrapIntrospector introspector;
    private final PojoRawTypeModel<E> indexedEntityType;
    private final PojoModelTypeRootElement<E> pojoModelTypeRootElement;
    private final PojoRoutingIndexingDependencyConfigurationContextImpl<E> dependencyContext;
    private BeanHolder<? extends RoutingBridge<? super E>> routingBridgeHolder;

    public RoutingBindingContextImpl(BeanResolver beanResolver, PojoBootstrapIntrospector introspector, PojoRawTypeModel<E> indexedEntityType, PojoModelTypeRootElement<E> pojoModelTypeRootElement, PojoRoutingIndexingDependencyConfigurationContextImpl<E> dependencyContext, Map<String, Object> params) {
        super(beanResolver, params);
        this.introspector = introspector;
        this.indexedEntityType = indexedEntityType;
        this.pojoModelTypeRootElement = pojoModelTypeRootElement;
        this.dependencyContext = dependencyContext;
    }

    public <E2> void bridge(Class<E2> expectedType, RoutingBridge<E2> bridge) {
        this.bridge(expectedType, (BeanHolder<? extends RoutingBridge<E2>>)BeanHolder.of(bridge));
    }

    public <E2> void bridge(Class<E2> expectedType, BeanHolder<? extends RoutingBridge<E2>> bridgeHolder) {
        PojoRawTypeModel<E2> expectedTypeModel = this.introspector.typeModel(expectedType);
        if (!this.indexedEntityType.isSubTypeOf(expectedTypeModel)) {
            throw MappingLog.INSTANCE.invalidInputTypeForRoutingBridge(bridgeHolder.get(), this.indexedEntityType, expectedTypeModel);
        }
        this.routingBridgeHolder = bridgeHolder;
    }

    @Override
    public PojoModelType bridgedElement() {
        return this.pojoModelTypeRootElement;
    }

    @Override
    public PojoRoutingIndexingDependencyConfigurationContext dependencies() {
        return this.dependencyContext;
    }

    public BoundRoutingBridge<E> applyBinder(RoutingBinder binder) {
        binder.bind(this);
        if (this.routingBridgeHolder == null) {
            throw MappingLog.INSTANCE.missingBridgeForBinder(binder);
        }
        RoutingBindingContextImpl.checkBridgeDependencies(this.pojoModelTypeRootElement, this.dependencyContext);
        return new BoundRoutingBridge<E>(this.routingBridgeHolder, this.pojoModelTypeRootElement, this.dependencyContext);
    }
}

