/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.impl;

import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverRootContext;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.common.annotation.impl.SearchProcessingWithContextException;
import org.hibernate.search.mapper.pojo.logging.impl.IndexingLog;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

public class PojoImplicitReindexingResolverPropertyNode<T, P>
extends PojoImplicitReindexingResolverNode<T> {
    private final ValueReadHandle<P> handle;
    private final PojoImplicitReindexingResolverNode<? super P> nested;
    private final PojoModelPath modelPath;

    public PojoImplicitReindexingResolverPropertyNode(ValueReadHandle<P> handle, PojoImplicitReindexingResolverNode<? super P> nested, PojoModelPath modelPath) {
        this.handle = handle;
        this.nested = nested;
        this.modelPath = modelPath;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(PojoImplicitReindexingResolverNode::close, this.nested);
        }
    }

    public void appendTo(ToStringTreeAppender appender) {
        appender.attribute("operation", (Object)"process property");
        appender.attribute("handle", this.handle);
        appender.attribute("nested", this.nested);
    }

    @Override
    public void resolveEntitiesToReindex(PojoReindexingCollector collector, T dirty, PojoImplicitReindexingResolverRootContext context) {
        try {
            Object propertyValue;
            try {
                propertyValue = this.handle.get(dirty);
            }
            catch (RuntimeException e) {
                context.propagateOrIgnorePropertyAccessException(e);
                return;
            }
            if (propertyValue != null) {
                this.nested.resolveEntitiesToReindex(collector, propertyValue, context);
            }
        }
        catch (SearchProcessingWithContextException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw IndexingLog.INSTANCE.searchProcessingFailure(e, e.getMessage(), PojoEventContexts.fromPath(this.modelPath));
        }
    }
}

