/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.QueryBuilder;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.FuzzyQueryBuilder;
import org.hibernate.search.backend.lucene.search.impl.AbstractLuceneCodecAwareSearchValueFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneTextMatchPredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private LuceneTextMatchPredicate(Builder builder) {
        super(builder);
    }

    private static class Builder<F>
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<F>
    implements MatchPredicateBuilder {
        private final LuceneStandardFieldCodec<F, String> codec;
        private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
        private String value;
        private Integer maxEditDistance;
        private Integer prefixLength;
        private Analyzer overrideAnalyzerOrNormalizer;

        private Builder(LuceneStandardFieldCodec<F, String> codec, LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            super(searchContext, field);
            this.codec = codec;
            this.analysisDefinitionRegistry = searchContext.analysisDefinitionRegistry();
        }

        public void value(Object value, ValueConvert convert) {
            this.value = this.convertAndEncode(this.codec, value, convert);
        }

        public void fuzzy(int maxEditDistance, int exactPrefixLength) {
            this.maxEditDistance = maxEditDistance;
            this.prefixLength = exactPrefixLength;
        }

        public void analyzer(String analyzerName) {
            this.overrideAnalyzerOrNormalizer = this.analysisDefinitionRegistry.getAnalyzerDefinition(analyzerName);
            if (this.overrideAnalyzerOrNormalizer == null) {
                throw log.unknownAnalyzer(analyzerName, this.field.eventContext());
            }
        }

        public void skipAnalysis() {
            this.overrideAnalyzerOrNormalizer = AnalyzerConstants.KEYWORD_ANALYZER;
        }

        public SearchPredicate build() {
            return new LuceneTextMatchPredicate(this);
        }

        @Override
        protected Query buildQuery() {
            Analyzer effectiveAnalyzerOrNormalizer = this.overrideAnalyzerOrNormalizer;
            if (effectiveAnalyzerOrNormalizer == null) {
                effectiveAnalyzerOrNormalizer = this.field.type().searchAnalyzerOrNormalizer();
            }
            if (effectiveAnalyzerOrNormalizer == AnalyzerConstants.KEYWORD_ANALYZER) {
                Term term = new Term(this.absoluteFieldPath, this.value);
                if (this.maxEditDistance != null) {
                    return new FuzzyQuery(term, this.maxEditDistance.intValue(), this.prefixLength.intValue());
                }
                return new TermQuery(term);
            }
            QueryBuilder effectiveQueryBuilder = this.maxEditDistance != null ? new FuzzyQueryBuilder(effectiveAnalyzerOrNormalizer, this.maxEditDistance, this.prefixLength) : new QueryBuilder(effectiveAnalyzerOrNormalizer);
            Query analyzed = effectiveQueryBuilder.createBooleanQuery(this.absoluteFieldPath, this.value);
            if (analyzed == null) {
                analyzed = new MatchNoDocsQuery("No tokens after analysis of the value to match");
            }
            return analyzed;
        }
    }

    public static class Factory<F>
    extends AbstractLuceneCodecAwareSearchValueFieldQueryElementFactory<MatchPredicateBuilder, F, LuceneStandardFieldCodec<F, String>> {
        public Factory(LuceneStandardFieldCodec<F, String> codec) {
            super(codec);
        }

        @Override
        public Builder<F> create(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            return new Builder((LuceneStandardFieldCodec)this.codec, searchContext, field);
        }
    }
}

