/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.GetResource;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;
import org.hibernate.validator.internal.util.privilegedactions.NewInstance;
import org.hibernate.validator.internal.util.privilegedactions.NewJaxbContext;
import org.hibernate.validator.internal.util.privilegedactions.NewSchema;
import org.hibernate.validator.internal.util.privilegedactions.Unmarshal;
import org.hibernate.validator.internal.xml.PropertyType;
import org.hibernate.validator.internal.xml.ValidationBootstrapParameters;
import org.hibernate.validator.internal.xml.ValidationConfigType;

public class ValidationXmlParser {
    private static final Log log = LoggerFactory.make();
    private static final String VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final String VALIDATION_CONFIGURATION_XSD = "META-INF/validation-configuration-1.0.xsd";

    public final ValidationBootstrapParameters parseValidationXml() {
        ValidationConfigType config = this.getValidationConfig();
        ValidationBootstrapParameters xmlParameters = new ValidationBootstrapParameters();
        if (config != null) {
            this.setProviderClassFromXml(config, xmlParameters);
            this.setMessageInterpolatorFromXml(config, xmlParameters);
            this.setTraversableResolverFromXml(config, xmlParameters);
            this.setConstraintFactoryFromXml(config, xmlParameters);
            this.setMappingStreamsFromXml(config, xmlParameters);
            this.setPropertiesFromXml(config, xmlParameters);
        }
        return xmlParameters;
    }

    private void setConstraintFactoryFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        String constraintFactoryClass = config.getConstraintValidatorFactory();
        if (constraintFactoryClass != null) {
            try {
                Class clazz = (Class)ValidationXmlParser.run(LoadClass.action(constraintFactoryClass, this.getClass()));
                xmlParameters.setConstraintValidatorFactory((ConstraintValidatorFactory)ValidationXmlParser.run(NewInstance.action(clazz, "constraint factory class")));
                log.usingConstraintFactory(constraintFactoryClass);
            }
            catch (ValidationException e) {
                throw log.getUnableToInstantiateConstraintFactoryClassException(constraintFactoryClass, e);
            }
        }
    }

    private void setPropertiesFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        for (PropertyType property : config.getProperty()) {
            if (log.isDebugEnabled()) {
                log.debugf("Found property '%s' with value '%s' in validation.xml.", property.getName(), property.getValue());
            }
            xmlParameters.addConfigProperty(property.getName(), property.getValue());
        }
    }

    private void setMappingStreamsFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        for (String mappingFileName : config.getConstraintMapping()) {
            log.debugf("Trying to open input stream for %s.", mappingFileName);
            InputStream in = this.getInputStreamForPath(mappingFileName);
            if (in == null) {
                throw log.getUnableToOpenInputStreamForMappingFileException(mappingFileName);
            }
            xmlParameters.addMapping(in);
        }
    }

    private void setMessageInterpolatorFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        String messageInterpolatorClass = config.getMessageInterpolator();
        if (messageInterpolatorClass != null) {
            try {
                Class clazz = (Class)ValidationXmlParser.run(LoadClass.action(messageInterpolatorClass, this.getClass()));
                xmlParameters.setMessageInterpolator((MessageInterpolator)clazz.newInstance());
                log.usingMessageInterpolator(messageInterpolatorClass);
            }
            catch (ValidationException e) {
                throw log.getUnableToInstantiateMessageInterpolatorClassException(messageInterpolatorClass, (Exception)((Object)e));
            }
            catch (InstantiationException e) {
                throw log.getUnableToInstantiateMessageInterpolatorClassException(messageInterpolatorClass, e);
            }
            catch (IllegalAccessException e) {
                throw log.getUnableToInstantiateMessageInterpolatorClassException(messageInterpolatorClass, e);
            }
        }
    }

    private void setTraversableResolverFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParameters) {
        String traversableResolverClass = config.getTraversableResolver();
        if (traversableResolverClass != null) {
            try {
                Class clazz = (Class)ValidationXmlParser.run(LoadClass.action(traversableResolverClass, this.getClass()));
                xmlParameters.setTraversableResolver((TraversableResolver)clazz.newInstance());
                log.usingTraversableResolver(traversableResolverClass);
            }
            catch (ValidationException e) {
                throw log.getUnableToInstantiateTraversableResolverClassException(traversableResolverClass, (Exception)((Object)e));
            }
            catch (InstantiationException e) {
                throw log.getUnableToInstantiateTraversableResolverClassException(traversableResolverClass, e);
            }
            catch (IllegalAccessException e) {
                throw log.getUnableToInstantiateTraversableResolverClassException(traversableResolverClass, e);
            }
        }
    }

    private void setProviderClassFromXml(ValidationConfigType config, ValidationBootstrapParameters xmlParamters) {
        String providerClassName = config.getDefaultProvider();
        if (providerClassName != null) {
            try {
                xmlParamters.setProviderClass((Class)ValidationXmlParser.run(LoadClass.action(providerClassName, this.getClass())));
                log.usingValidationProvider(providerClassName);
            }
            catch (Exception e) {
                throw log.getUnableToInstantiateValidationProviderClassException(providerClassName, e);
            }
        }
    }

    private ValidationConfigType getValidationConfig() {
        log.debugf("Trying to load %s for XML based Validator configuration.", VALIDATION_XML_FILE);
        InputStream inputStream = this.getInputStreamForPath(VALIDATION_XML_FILE);
        if (inputStream == null) {
            log.debugf("No %s found. Using annotation based configuration only.", VALIDATION_XML_FILE);
            return null;
        }
        log.parsingXMLFile(VALIDATION_XML_FILE);
        Schema schema = this.getValidationConfigurationSchema();
        try {
            JAXBContext jc = ValidationXmlParser.run(NewJaxbContext.action(ValidationConfigType.class));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            StreamSource stream = new StreamSource(inputStream);
            JAXBElement root = (JAXBElement)ValidationXmlParser.run(Unmarshal.action(unmarshaller, stream, ValidationConfigType.class));
            ValidationConfigType validationConfigType = (ValidationConfigType)root.getValue();
            return validationConfigType;
        }
        catch (Exception e) {
            throw log.getUnableToParseValidationXmlFileException(VALIDATION_XML_FILE, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException io) {
                log.unableToCloseXMLFileInputStream(VALIDATION_XML_FILE);
            }
        }
    }

    private InputStream getInputStreamForPath(String path) {
        String inputPath = path;
        if (inputPath.startsWith("/")) {
            inputPath = inputPath.substring(1);
        }
        boolean isContextCL = true;
        ClassLoader loader = ValidationXmlParser.run(GetClassLoader.fromContext());
        if (loader == null) {
            log.debug("No default context class loader, fall back to Bean Validation's loader");
            loader = ValidationXmlParser.run(GetClassLoader.fromClass(ValidationXmlParser.class));
            isContextCL = false;
        }
        InputStream inputStream = loader.getResourceAsStream(inputPath);
        if (isContextCL && inputStream == null) {
            loader = ValidationXmlParser.run(GetClassLoader.fromClass(ValidationXmlParser.class));
            inputStream = loader.getResourceAsStream(inputPath);
        }
        return inputStream;
    }

    private Schema getValidationConfigurationSchema() {
        ClassLoader loader = ValidationXmlParser.run(GetClassLoader.fromClass(ValidationXmlParser.class));
        URL schemaUrl = ValidationXmlParser.run(GetResource.action(loader, VALIDATION_CONFIGURATION_XSD));
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = ValidationXmlParser.run(NewSchema.action(sf, schemaUrl));
        }
        catch (Exception e) {
            log.unableToCreateSchema(VALIDATION_CONFIGURATION_XSD, e.getMessage());
        }
        return schema;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private static <T> T run(PrivilegedExceptionAction<T> action) throws Exception {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

