/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.v2.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Filter;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.query.dsl.v2.TermMatchingContext;
import org.hibernate.search.query.dsl.v2.WildcardContext;
import org.hibernate.search.query.dsl.v2.impl.ConnectedTermMatchingContext;
import org.hibernate.search.query.dsl.v2.impl.QueryContext;
import org.hibernate.search.query.dsl.v2.impl.QueryCustomizer;

class ConnectedWildcardContext
implements WildcardContext {
    private final SearchFactory factory;
    private final Analyzer queryAnalyzer;
    private final QueryCustomizer queryCustomizer;
    private final QueryContext context;

    public ConnectedWildcardContext(Analyzer queryAnalyzer, SearchFactory factory) {
        this.factory = factory;
        this.queryAnalyzer = queryAnalyzer;
        this.queryCustomizer = new QueryCustomizer();
        this.context = new QueryContext(QueryContext.Approximation.WILDCARD);
    }

    public TermMatchingContext onField(String field) {
        return new ConnectedTermMatchingContext(this.context, field, this.queryCustomizer, this.queryAnalyzer, this.factory);
    }

    public WildcardContext boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    public WildcardContext constantScore() {
        this.queryCustomizer.constantScore();
        return this;
    }

    public WildcardContext filter(Filter filter) {
        this.queryCustomizer.filter(filter);
        return this;
    }
}

