/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.works.ByTermDeleteWorkExecutor;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.store.Workspace;

public final class DeleteExtWorkExecutor
extends ByTermDeleteWorkExecutor {
    private final IndexedTypeIdentifier managedType;
    private final DocumentBuilderIndexedEntity builder;
    private final boolean idIsNumeric;

    DeleteExtWorkExecutor(Workspace workspace) {
        super(workspace);
        this.managedType = (IndexedTypeIdentifier)workspace.getEntitiesInIndexManager().iterator().next();
        this.builder = workspace.getDocumentBuilder(this.managedType);
        this.idIsNumeric = DeleteExtWorkExecutor.isIdNumeric(this.builder);
    }

    @Override
    public void performWork(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor) {
        this.checkType(work);
        this.doPerformWork(work, delegate, this.managedType, this.builder, this.idIsNumeric);
    }

    private void checkType(LuceneWork work) {
        if (!work.getEntityType().equals(this.managedType)) {
            throw new AssertionFailure("Unexpected type");
        }
    }
}

