/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.filter.FilterKey;

public class StandardFilterKey
extends FilterKey {
    private final List<Object> parameters = new ArrayList<Object>();
    private boolean implSet;

    @Override
    public void setImpl(Class<?> impl) {
        super.setImpl(impl);
        if (this.implSet) {
            this.parameters.set(0, impl);
        } else {
            this.implSet = true;
            this.parameters.add(0, impl);
        }
    }

    public void addParameter(Object value) {
        this.parameters.add(value);
    }

    @Override
    public int hashCode() {
        int hash = 23;
        for (Object param : this.parameters) {
            hash = 31 * hash + (param != null ? param.hashCode() : 0);
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof StandardFilterKey)) {
            return false;
        }
        StandardFilterKey that = (StandardFilterKey)obj;
        int size = this.parameters.size();
        if (size != that.parameters.size()) {
            return false;
        }
        for (int index = 0; index < size; ++index) {
            Object paramThis = this.parameters.get(index);
            Object paramThat = that.parameters.get(index);
            if (paramThis == null && paramThat != null) {
                return false;
            }
            if (paramThis == null || paramThis.equals(paramThat)) continue;
            return false;
        }
        return true;
    }
}

