/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.DistanceFilter;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.QuadTreeFilter;
import org.hibernate.search.spatial.impl.Rectangle;
import org.hibernate.search.spatial.impl.SpatialHelper;

public abstract class SpatialQueryBuilderFromCoordinates {
    public static Filter buildQuadTreeFilter(Coordinates center, double radius, String fieldName) {
        int bestQuadTreeLevel = SpatialHelper.findBestQuadTreeLevelForSearchRange(2.0 * radius);
        if (bestQuadTreeLevel > 16) {
            bestQuadTreeLevel = 16;
        }
        List<String> quadTreeCellsIds = SpatialHelper.getQuadTreeCellsIds(center, radius, bestQuadTreeLevel);
        return new QuadTreeFilter(quadTreeCellsIds, SpatialHelper.formatFieldName(bestQuadTreeLevel, fieldName));
    }

    public static Filter buildDistanceFilter(Filter previousFilter, Coordinates center, double radius, String coordinatesField) {
        return new DistanceFilter(previousFilter, center, radius, coordinatesField);
    }

    public static Filter buildDistanceFilter(Filter previousFilter, Coordinates center, double radius, String latitudeField, String longitudeField) {
        return new DistanceFilter(previousFilter, center, radius, latitudeField, longitudeField);
    }

    public static Query buildQuadTreeQuery(Coordinates center, double radius, String fieldName) {
        return new FilteredQuery((Query)new MatchAllDocsQuery(), SpatialQueryBuilderFromCoordinates.buildQuadTreeFilter(center, radius, fieldName));
    }

    public static Query buildDistanceQuery(Coordinates center, double radius, String fieldName) {
        QueryWrapperFilter allFilter = new QueryWrapperFilter((Query)new MatchAllDocsQuery());
        return new FilteredQuery((Query)new MatchAllDocsQuery(), SpatialQueryBuilderFromCoordinates.buildDistanceFilter((Filter)allFilter, center, radius, fieldName));
    }

    public static Query buildSpatialQueryByQuadTree(Coordinates center, double radius, String fieldName) {
        return new FilteredQuery((Query)new MatchAllDocsQuery(), SpatialQueryBuilderFromCoordinates.buildDistanceFilter(SpatialQueryBuilderFromCoordinates.buildQuadTreeFilter(center, radius, fieldName), center, radius, fieldName));
    }

    public static Query buildSpatialQueryByRange(Coordinates centerCoordinates, double radius, String fieldName) {
        Point center = Point.fromCoordinates(centerCoordinates);
        Rectangle boundingBox = Rectangle.fromBoundingCircle(center, radius);
        String latitudeFieldName = fieldName + "_HSSI_Latitude";
        String longitudeFieldName = fieldName + "_HSSI_Longitude";
        NumericRangeQuery latQuery = NumericRangeQuery.newDoubleRange((String)latitudeFieldName, (Double)boundingBox.getLowerLeft().getLatitude(), (Double)boundingBox.getUpperRight().getLatitude(), (boolean)true, (boolean)true);
        BooleanQuery longQuery = null;
        if (boundingBox.getLowerLeft().getLongitude() <= boundingBox.getUpperRight().getLongitude()) {
            longQuery = NumericRangeQuery.newDoubleRange((String)longitudeFieldName, (Double)boundingBox.getLowerLeft().getLongitude(), (Double)boundingBox.getUpperRight().getLongitude(), (boolean)true, (boolean)true);
        } else {
            longQuery = new BooleanQuery();
            longQuery.add((Query)NumericRangeQuery.newDoubleRange((String)longitudeFieldName, (Double)boundingBox.getLowerLeft().getLongitude(), (Double)180.0, (boolean)true, (boolean)true), BooleanClause.Occur.SHOULD);
            longQuery.add((Query)NumericRangeQuery.newDoubleRange((String)longitudeFieldName, (Double)-180.0, (Double)boundingBox.getUpperRight().getLongitude(), (boolean)true, (boolean)true), BooleanClause.Occur.SHOULD);
        }
        BooleanQuery boxQuery = new BooleanQuery();
        boxQuery.add((Query)latQuery, BooleanClause.Occur.MUST);
        boxQuery.add((Query)longQuery, BooleanClause.Occur.MUST);
        return new FilteredQuery((Query)new MatchAllDocsQuery(), SpatialQueryBuilderFromCoordinates.buildDistanceFilter((Filter)new QueryWrapperFilter((Query)boxQuery), center, radius, latitudeFieldName, longitudeFieldName));
    }
}

