/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.Date;
import java.util.List;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.dsl.impl.RangeFacetImpl;
import org.hibernate.search.query.facet.Facet;

public class RangeFacetRequest<T>
extends FacetingRequestImpl {
    private final List<FacetRange<T>> facetRangeList;
    private final DocumentBuilderIndexedEntity<?> documentBuilder;

    RangeFacetRequest(String name, String fieldName, List<FacetRange<T>> facetRanges, DocumentBuilderIndexedEntity<?> documentBuilder) {
        super(name, fieldName);
        if (facetRanges == null || facetRanges.isEmpty()) {
            throw new IllegalArgumentException("At least one facet range must be specified");
        }
        this.facetRangeList = facetRanges;
        this.documentBuilder = documentBuilder;
    }

    public List<FacetRange<T>> getFacetRangeList() {
        return this.facetRangeList;
    }

    @Override
    public Class<?> getFieldCacheType() {
        T o = this.facetRangeList.get(0).getMin();
        if (o == null) {
            o = this.facetRangeList.get(0).getMax();
        }
        if (o instanceof Date) {
            return String.class;
        }
        return o.getClass();
    }

    @Override
    public Facet createFacet(String value, int count) {
        int facetIndex = this.findFacetRangeIndex(value);
        FacetRange<T> range = this.facetRangeList.get(facetIndex);
        return new RangeFacetImpl<T>(this.getFacetingName(), this.getFieldName(), range, count, facetIndex, this.documentBuilder);
    }

    @Override
    public String toString() {
        return "RangeFacetRequest{facetRangeList=" + this.facetRangeList + "} " + super.toString();
    }

    private int findFacetRangeIndex(String value) {
        int index = 0;
        for (FacetRange<T> facetRange : this.facetRangeList) {
            if (facetRange.getRangeString().equals(value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

